package net.darkhax.bookshelf.common.impl.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.commands.args.TagArgument;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class BlockTagToItemTagCommand {

    public static LiteralArgumentBuilder<class_2168> build(class_7157 context) {
        final LiteralArgumentBuilder<class_2168> root = class_2170.method_9247("block_to_item_tag").requires(PermissionLevel.GAMEMASTER);
        root.then(class_2170.method_9244("block_tag", TagArgument.arg(context, class_7924.field_41254)).executes(ctx -> {
            final class_6862<class_2248> result = TagArgument.get("block_tag", ctx, class_7924.field_41254);
            final class_6885.class_6888<class_2248> tag = class_7923.field_41175.method_40266(result).orElseThrow();
            final Set<class_1747> items = new HashSet<>();
            for (class_1792 item : class_7923.field_41178) {
                if (item instanceof class_1747 blockItem && tag.method_40241(blockItem.method_7711().method_40142())) {
                    items.add(blockItem);
                }
            }
            ctx.getSource().method_9226(() -> TextHelper.copyText(Constants.GSON_PRETTY.toJson(tagJson(items, class_7923.field_41178::method_10221))), false);
            return 0;
        }));
        return root;
    }

    private static <T> JsonObject tagJson(Collection<T> entries, Function<T, class_2960> idFunc) {
        final JsonArray array = new JsonArray();
        entries.stream().map(entry -> idFunc.apply(entry).toString()).sorted().forEach(array::add);
        final JsonObject obj = new JsonObject();
        obj.add("values", array);
        return obj;
    }
}
