package net.darkhax.bookshelf.common.api.util;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class DataHelper {

    public static <T> class_6885<T> getTagOrEmpty(@Nullable class_7225.class_7874 provider, class_5321<class_2378<T>> registryKey, class_6862<T> tag) {
        if (provider != null) {
            final Optional<class_6885.class_6888<T>> optional = provider.method_46762(registryKey).method_46733(tag);
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return class_6885.method_40246();
    }

    /**
     * Creates a sublist of a ListTag. Unlike {@link java.util.AbstractList#subList(int, int)}, the sublist is a new
     * list instance and changes to the original will not be propagated.
     *
     * @param list The list to create a sublist from.
     * @param from The starting index.
     * @param to   The ending index.
     * @return A sublist created from the input list.
     */
    public static class_2499 subList(class_2499 list, int from, int to) {
        if (list == null) {
            throw new IllegalStateException("The input list must not be null!");
        }
        if (from < 0 || to > list.size() || from > to) {
            throw new IndexOutOfBoundsException("Invalid range! from=" + from + " to=" + to + " size=" + list.size());
        }
        final class_2499 subList = new class_2499();
        for (int i = from; i < to; i++) {
            subList.add(list.method_10534(i));
        }
        return subList;
    }

    /**
     * Creates a sublist of an inventory tag based on a predicate on the slot indexes.
     *
     * @param list  The inventory list tag.
     * @param slots A predicate for which item slots should be included in the sublist.
     * @return A sublist created from the input list.
     */
    public static class_2499 containerSubList(class_2499 list, Predicate<Integer> slots) {
        if (list == null) {
            throw new IllegalStateException("The input list must not be null!");
        }
        final class_2499 subList = new class_2499();
        for (class_2520 tag : list) {
            if (tag instanceof class_2487 entry && entry.method_10573("Slot", class_2520.field_33251) && slots.test(entry.method_10550("Slot"))) {
                subList.add(tag);
            }
        }
        return subList;
    }

    /**
     * Creates a new stream codec for an optional value.
     *
     * @param streamCodec A codec that can serialize the content type.
     * @param <B>         The type of the byte buffer.
     * @param <V>         The content type of the stream.
     * @return An optional stream codec.
     */
    public static <B extends ByteBuf, V> class_9139<B, Optional<V>> optionalStream(class_9139<B, V> streamCodec) {
        return class_9139.method_56437(
                (buf, val) -> {
                    buf.writeBoolean(val.isPresent());
                    val.ifPresent(v -> streamCodec.encode(buf, v));
                },
                buf -> {
                    if (buf.readBoolean()) {
                        final V val = streamCodec.decode(buf);
                        return Optional.of(val);
                    }
                    return Optional.empty();
                });
    }

    /**
     * Creates a new recipe serializer.
     *
     * @param codec  A codec for JSON/NBT data.
     * @param stream A codec for networking.
     * @param <T>    The type of the recipe.
     * @return A recipe serializer object.
     */
    public static <T extends class_1860<?>> class_1865<T> recipeSerializer(MapCodec<T> codec, class_9139<class_9129, T> stream) {
        return new class_1865<>() {
            @NotNull
            @Override
            public MapCodec<T> method_53736() {
                return codec;
            }

            @NotNull
            @Override
            public class_9139<class_9129, T> method_56104() {
                return stream;
            }
        };
    }
}
