package net.darkhax.bookshelf.common.api.registry.register;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.darkhax.bookshelf.common.api.entity.villager.MerchantTier;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisterVillagerTrades {

    private final Map<class_3852, Multimap<Integer, class_3853.class_1652>> villagerTrades = new HashMap<>();
    private final List<class_3853.class_1652> rareTrades = new ArrayList<>();
    private final List<class_3853.class_1652> commonTrades = new ArrayList<>();

    /**
     * Adds a new trade listing to a specific profession that may become available when the specified profession tier is
     * reached.
     *
     * @param profession The profession to register the trade to.
     * @param tier       The tier at which this trade can become available.
     * @param trade      The trade listing to add.
     */
    public void addTrade(class_3852 profession, int tier, class_3853.class_1652 trade) {
        villagerTrades.computeIfAbsent(profession, p -> ArrayListMultimap.create()).put(tier, trade);
    }

    /**
     * Adds a new trade listing to a specific profession that may become available when the specified profession tier is
     * reached.
     *
     * @param profession The profession to register the trade to.
     * @param tier       The tier at which this trade can become available.
     * @param trade      The trade listing to add.
     */
    public void addTrade(class_3852 profession, MerchantTier tier, class_3853.class_1652 trade) {
        this.addTrade(profession, tier.ordinal() + 1, trade);
    }

    /**
     * Adds a trade to the wandering villager trade pool.
     *
     * @param trade  The trade to add.
     * @param isRare If the trade belongs in the rare or common pool.
     */
    public void addWanderingTrade(class_3853.class_1652 trade, boolean isRare) {
        (isRare ? rareTrades : commonTrades).add(trade);
    }

    /**
     * Adds a trade to the wandering traders rare trades pool.
     *
     * @param trade The trade to add.
     */
    public void addRareWanderingTrade(class_3853.class_1652 trade) {
        this.addWanderingTrade(trade, true);
    }

    /**
     * Adds a trade to the wandering traders common trade pool.
     *
     * @param trade The trade to add.
     */
    public void addCommonWanderingTrade(class_3853.class_1652 trade) {
        this.addWanderingTrade(trade, false);
    }

    public Map<class_3852, Multimap<Integer, class_3853.class_1652>> getVillagerTrades() {
        return Collections.unmodifiableMap(this.villagerTrades);
    }

    public List<class_3853.class_1652> getRareWanderingTrades() {
        return Collections.unmodifiableList(this.rareTrades);
    }

    public List<class_3853.class_1652> getCommonWanderingTrades() {
        return Collections.unmodifiableList(this.commonTrades);
    }
}