package net.darkhax.bookshelf.common.api.network;

import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

/**
 * Provides platform specific implementations of network related code. Access using
 * {@link net.darkhax.bookshelf.common.api.service.Services#NETWORK}.
 */
public interface INetworkHandler {

    /**
     * Registers a Bookshelf packet type to the packet registry.
     *
     * @param packet The packet type to register.
     * @param <T>    The type of the payload.
     */
    <T extends class_8710> void register(IPacket<T> packet);

    /**
     * Sends a payload from the client to the server.
     *
     * @param payload The payload to send.
     * @param <T>     The type of the payload.
     */
    <T extends class_8710> void sendToServer(T payload);

    /**
     * Sends a packet from the server to a player.
     *
     * @param recipient The recipient of the packet.
     * @param payload   The payload to send.
     * @param <T>       The type of the payload.
     */
    <T extends class_8710> void sendToPlayer(class_3222 recipient, T payload);

    /**
     * Tests if a payload type can be sent to a player.
     *
     * @param recipient The recipient of the packet.
     * @param payload   The payload to test.
     * @return If the payload can be sent to the recipient player.
     */
    default boolean canSendPacket(class_3222 recipient, class_8710 payload) {
        return this.canSendPacket(recipient, payload.method_56479().comp_2242());
    }

    /**
     * Tests if a payload type can be sent to a player.
     *
     * @param recipient The recipient of the packet.
     * @param packet    The packet to test.
     * @return If the payload can be sent to the recipient player.
     */
    default boolean canSendPacket(class_3222 recipient, IPacket<?> packet) {
        return this.canSendPacket(recipient, packet.type().comp_2242());
    }

    /**
     * Tests if a payload type can be sent to a player.
     *
     * @param recipient The recipient of the packet.
     * @param payloadId The payload type ID.
     * @return If the payload can be sent to the recipient player.
     */
    boolean canSendPacket(class_3222 recipient, class_2960 payloadId);
}