package net.darkhax.bookshelf.common.api.menu.data;

import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_3913;

/**
 * Allows a block position to be kept in sync using the container system. The server should always construct this
 * directly while the client should use SimpleContainerData with size of 3.
 */
public class BlockPosData implements class_3913 {

    private final int[] pos;
    private final boolean mutable;

    public BlockPosData(class_2338 pos) {
        this(pos, false);
    }

    public BlockPosData(class_2338 pos, boolean mutable) {
        this.pos = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
        this.mutable = mutable;
    }

    @Override
    public int method_17390(int slot) {
        return pos[slot];
    }

    @Override
    public void method_17391(int slot, int value) {
        if (this.mutable) {
            pos[slot] = value;
        }
    }

    @Override
    public int method_17389() {
        return 3;
    }

    /**
     * Gets the BlockPos currently held by the container data. This should only be called on the server.
     *
     * @return The BlockPos being held.
     */
    public class_2338 getPos() {
        return new class_2338(pos[0], pos[1], pos[2]);
    }

    /**
     * Reads a BlockPos from untyped container data. This should be used to read the position on the client which should
     * be using a SimpleContainerData and not a BlockPosData.
     *
     * @param data The data to read from.
     * @return The BlockPos that was ready.
     */
    public static class_2338 readPos(class_3913 data) {
        if (data.method_17389() != 3) {
            throw new IllegalStateException("Can not read BlockPos from container data. Expected 3 values, found " + data.method_17389() + ". data=" + Arrays.toString(toArray(data)));
        }
        return new class_2338(data.method_17390(0), data.method_17390(1), data.method_17390(2));
    }

    private static int[] toArray(class_3913 containerData) {
        final int[] data = new int[containerData.method_17389()];
        for (int i = 0; i < containerData.method_17389(); i++) {
            data[i] = containerData.method_17390(i);
        }
        return data;
    }
}
