package net.darkhax.bookshelf.common.mixin.patch.level;

import net.darkhax.bookshelf.common.api.block.IBlockHooks;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_14.class)
public class MixinWalkNodeEvaluator {

    /**
     * This patch allows modded blocks to control their own pathfinding type. This is done by implementing
     * {@link IBlockHooks#getPathfindingType(class_2680, class_1922, class_2338)}.
     */
    @Inject(method = "getPathTypeFromState(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/pathfinder/PathType;", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;"), locals = LocalCapture.CAPTURE_FAILSOFT, cancellable = true)
    private static void getBlockPathTypeRaw(class_1922 level, class_2338 pos, CallbackInfoReturnable<class_7> cbi, class_2680 state) {
        if (state.method_26204() instanceof IBlockHooks hooks) {
            final class_7 customType = hooks.getPathfindingType(state, level, pos);
            if (customType != null) {
                cbi.setReturnValue(customType);
            }
        }
    }
}