package net.darkhax.bookshelf.common.impl.data.conditions;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.conditions.ConditionType;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import java.util.Set;

public class RegistryContains<T> implements ILoadCondition {

    public static final class_2960 BLOCK = Constants.id("block_exists");
    public static final class_2960 ITEM = Constants.id("item_exists");
    public static final class_2960 ENTITY = Constants.id("entity_exists");
    public static final class_2960 BLOCK_ENTITY = Constants.id("block_entity_exists");

    private final class_2378<T> registry;
    private final Set<class_2960> requiredIds;
    private final CachedSupplier<ConditionType> type;


    public static <RT> MapCodec<RegistryContains<RT>> of(class_2960 typeId, class_2378<RT> registry) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(
                MapCodecs.RESOURCE_LOCATION.getSet("values", RegistryContains::getRequiredEntries)
        ).apply(instance, requiredEntries -> new RegistryContains<>(typeId, registry, requiredEntries)));
    }

    private RegistryContains(class_2960 typeId, class_2378<T> registry, Set<class_2960> requiredIds) {
        this.registry = registry;
        this.requiredIds = requiredIds;
        this.type = CachedSupplier.cache(() -> LoadConditions.getType(typeId));
    }

    @Override
    public boolean allowLoading() {
        for (class_2960 id : this.requiredIds) {
            if (!this.registry.method_10250(id)) {
                return false;
            }
        }
        return true;
    }

    public Set<class_2960> getRequiredEntries() {
        return this.requiredIds;
    }

    @Override
    public ConditionType getType() {
        return this.type.get();
    }
}