package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.commands.args.FontArgument;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBannerBlockEntity;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBaseContainerBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2262;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8242;
import net.minecraft.class_9334;
import java.util.function.UnaryOperator;

public class FontCommand {

    public static LiteralArgumentBuilder<class_2168> build() {
        final LiteralArgumentBuilder<class_2168> font = class_2170.method_9247("font").requires(PermissionLevel.GAMEMASTER);

        LiteralArgumentBuilder<class_2168> rename = class_2170.method_9247("rename");
        rename.then(FontArgument.argument().executes(FontCommand::renameItemWithFont));
        rename.then(class_2170.method_9244("target", class_2186.method_9309()).then(FontArgument.argument().executes(FontCommand::renameItemWithFont)));
        font.then(rename);

        font.then(class_2170.method_9247("block").then(FontArgument.argument().then(class_2170.method_9244("pos", class_2262.method_9698()).executes(FontCommand::renameBlockWithFont))));
        font.then(class_2170.method_9247("say").then(FontArgument.argument().then(class_2170.method_9244("message", class_2196.method_9340()).executes(FontCommand::speakWithFont))));
        return font;
    }

    private static int speakWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        final class_2960 fontId = FontArgument.get(context);
        final class_2561 inputMessage = TextHelper.applyFont(class_2196.method_9339(context, "message"), fontId);
        final class_2561 txtMessage = class_2561.method_43469("chat.type.announcement", context.getSource().method_9223(), inputMessage);
        context.getSource().method_9211().method_3760().method_43514(txtMessage, false);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {

        final class_2960 fontId = FontArgument.get(context);
        final class_1297 target = CommandHelper.getEntityOrSender("target", context);

        if (target instanceof class_1309 living) {
            final class_1799 stack = living.method_6047();
            if (stack.method_7960()) {
                context.getSource().method_9213(class_2561.method_43471("commands.bookshelf.hand.error.not_air"));
                return 0;
            }
            stack.method_57379(class_9334.field_49631, TextHelper.applyFont(stack.method_7964().method_27661(), fontId));
            return 1;
        }
        context.getSource().method_9213(class_2561.method_43471("commands.bookshelf.font.bad_sender"));
        return 0;
    }

    private static int renameBlockWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        final ServerLevel world = context.getSource().getLevel();
        final ResourceLocation fontId = FontArgument.get(context);
        final BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, "pos");
        final BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && tile.hasLevel()) {
            switch (tile) {
                case BaseContainerBlockEntity container when tile instanceof AccessorBaseContainerBlockEntity accessor ->
                        accessor.bookshelf$name(TextHelper.applyFont(container.getName().copy(), fontId));
                case SignBlockEntity sign -> {
                    sign.updateText(applySignFont(fontId), true);
                    sign.updateText(applySignFont(fontId), false);
                    sign.getLevel().sendBlockUpdated(sign.getBlockPos(), sign.getBlockState(), sign.getBlockState(), 3);
                }
                case BannerBlockEntity banner when banner.hasCustomName() && banner instanceof AccessorBannerBlockEntity accessor ->
                        accessor.setName(TextHelper.applyFont(banner.getCustomName(), fontId));
                default ->
                        context.getSource().sendFailure(Component.translatable("commands.bookshelf.font.unsupported_block", tile.getBlockState().getBlock().getName()));
            }
        }
        return 1;
    }

    private static UnaryOperator<class_8242> applySignFont(class_2960 fontId) {
        return text -> {
            class_8242 newText = text;
            for (int i = 0; i < 4; i++) {
                newText = newText.method_49857(i, TextHelper.applyFont(text.method_49859(i, false).method_27661(), fontId));
            }
            return newText;
        };
    }
}
