package net.darkhax.bookshelf.common.api.text.unit;

import net.darkhax.bookshelf.common.api.text.format.PropertyFormat;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public interface IUnit {

    /**
     * A namespaced identifier that is used to derive localization keys for the unit.
     *
     * @return The namespace ID for the unit.
     */
    class_2960 unitKey();

    /**
     * Gets the name of the unit.
     *
     * @return The name of the unit.
     */
    default class_5250 unitName() {
        return class_2561.method_43471("units." + this.unitKey().method_12836() + "." + this.unitKey().method_12832());
    }

    /**
     * Gets the plural name of the unit.
     *
     * @return The plural name of the unit.
     */
    default class_5250 plural() {
        return class_2561.method_43471("units.bookshelf." + this.unitKey().method_12836() + "." + this.unitKey() + ".plural");
    }

    /**
     * Gets the abbreviated name of the unit.
     *
     * @return The abbreviated name of the unit.
     */
    default class_5250 abbreviated() {
        return class_2561.method_43471("units." + this.unitKey().method_12836() + "." + this.unitKey() + ".abbreviated");
    }

    /**
     * Formats an amount of the unit as a text component.
     *
     * @param amount The amount of the unit.
     * @return The formatted text. If the amount is plural the plural name will be used.
     */
    default class_5250 format(int amount) {
        return format(amount, PropertyFormat.LEFT);
    }

    /**
     * Formats an amount of the unit as a text component.
     *
     * @param amount The amount of the unit.
     * @param format The property format to use when displaying the unit and value.
     * @return The formatted text. If the amount is plural the plural name will be used instead.
     */
    default class_5250 format(int amount, PropertyFormat format) {
        return format.format((amount == 1 || amount == -1) ? this.unitName() : this.plural(), class_2561.method_43470(Integer.toString(amount)));
    }
}