package net.darkhax.bookshelf.common.api.registry.register;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_4002;
import net.minecraft.class_707;
import net.minecraft.class_7923;

public record RegisterParticleProviders(String owner, BiConsumer<class_2400, SimpleParticleProviderBuilder> registerSimple) {

    public void add(Supplier<class_2400> type, SimpleParticleProviderBuilder provider) {
        this.add(type.get(), provider);
    }

    public void add(String id, SimpleParticleProviderBuilder provider) {
        this.add(class_2960.method_43902(this.owner, id), provider);
    }

    public void add(class_2960 id, SimpleParticleProviderBuilder provider) {
        if (class_7923.field_41180.method_10250(id)) {
            final class_2396<?> type = class_7923.field_41180.method_10223(id);
            if (type instanceof class_2400 simpleType) {
                this.add(simpleType, provider);
            }
            else {
                throw new IllegalStateException("Particle type '" + id + "' is not a SimpleParticleType! type=" + type);
            }
        }
        else {
            throw new IllegalStateException("Particle type '" + id + "' has not been registered.");
        }
    }

    public void add(class_2400 type, SimpleParticleProviderBuilder provider) {
        this.registerSimple.accept(type, provider);
    }

    public interface SimpleParticleProviderBuilder {
        <T extends class_4002> class_707<class_2400> build(T sprite);
    }
}
