package net.darkhax.bookshelf.common.api.menu.slot;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

/**
 * A basic output slot implementation.
 */
public class OutputSlot extends class_1735 {

    @Nullable
    private final BiConsumer<class_1657, class_1799> takeFunc;

    public OutputSlot(class_1263 potContainer, int slot, int x, int y) {
        this(potContainer, slot, x, y, null);
    }

    public OutputSlot(class_1263 potContainer, int slot, int x, int y, @Nullable BiConsumer<class_1657, class_1799> takeFunc) {
        super(potContainer, slot, x, y);
        this.takeFunc = takeFunc;
    }

    @Override
    public boolean method_7680(@NotNull class_1799 stack) {
        return false;
    }

    @Override
    public void method_7667(@NotNull class_1657 player, @NotNull class_1799 stack) {
        super.method_7667(player, stack);
        if (this.takeFunc != null) {
            this.takeFunc.accept(player, stack);
        }
    }
}