package net.darkhax.bookshelf.common.api.menu.slot;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

/**
 * A basic input slot implementation.
 */
public class InputSlot extends class_1735 {

    private final class_2960 emptyTexture;
    private final Predicate<class_1799> canPlace;
    
    public InputSlot(class_1263 container, int slot, int x, int y, class_2960 emptyTexture) {
        this(container, slot, x, y, emptyTexture, stack -> true);
    }

    public InputSlot(class_1263 container, int slot, int x, int y, class_2960 emptyTexture, Predicate<class_1799> canPlace) {
        super(container, slot, x, y);
        this.emptyTexture = emptyTexture;
        this.canPlace = canPlace;
    }

    @Override
    public int method_7675() {
        return 1;
    }

    @Nullable
    @Override
    public Pair<class_2960, class_2960> method_7679() {
        return Pair.of(class_1723.field_21668, this.emptyTexture);
    }

    @Override
    public boolean method_7680(@NotNull class_1799 stack) {
        return this.canPlace.test(stack);
    }
}