package net.darkhax.bookshelf.common.api.loot;

import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_5455;
import net.minecraft.class_79;

/**
 * Describes the potential items that a loot pool entry can generate. See {@link LootPoolEntryDescriptions} for usage.
 */
@FunctionalInterface
public interface LootPoolEntryDescriber {

    /**
     * Describes items that may potentially be dropped by a loot pool entry.
     *
     * @param registries Access to the current game registries.
     * @param entry      The loot pool entry to be processed.
     * @param collector  Collects entries from the entry into the desired format.
     */
    void getPotentialDrops(@NotNull class_5455 registries, @NotNull class_79 entry, Consumer<class_1799> collector);
}