package net.darkhax.bookshelf.common.api.function;

import net.darkhax.bookshelf.common.mixin.access.level.AccessorRecipeManager;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SidedReloadableCache<T> implements Function<class_1937, T> {

    private final ReloadableCache<T> client;
    private final ReloadableCache<T> server;

    public SidedReloadableCache(ReloadableCache<T> client, ReloadableCache<T> server) {
        this.client = client;
        this.server = server;
    }

    public ReloadableCache<T> getCache(class_1937 level) {
        return level.field_9236 ? client : server;
    }

    @Nullable
    @Override
    public T apply(class_1937 level) {
        return getCache(level).apply(level);
    }

    public void invalidate(class_1937 level) {
        getCache(level).invalidate();
    }

    public boolean isCached(class_1937 level) {
        return getCache(level).isCached();
    }

    public void apply(class_1937 level, Consumer<T> consumer) {
        getCache(level).apply(level, consumer);
    }

    public void ifPresent(class_1937 level, Consumer<T> consumer) {
        getCache(level).ifPresent(level, consumer);
    }

    @Nullable
    public <R> R map(class_1937 level, Function<T, R> mapper) {
        return getCache(level).map(level, mapper);
    }

    public static <T> SidedReloadableCache<T> of(Function<class_1937, T> cacheFunc) {
        return new SidedReloadableCache<>(new ReloadableCache<>(cacheFunc), new ReloadableCache<>(cacheFunc));
    }

    @SuppressWarnings("unchecked")
    public static <T extends class_1860<?>> SidedReloadableCache<Map<class_2960, class_8786<T>>> recipes(Supplier<class_3956<T>> type) {
        return of(level -> {
            final Map<class_2960, class_8786<T>> byId = new HashMap<>();
            if (level.method_8433() instanceof AccessorRecipeManager accessor) {
                final Collection<class_8786<?>> recipes = accessor.bookshelf$byTypeMap().get(type.get());
                recipes.forEach(entry -> byId.put(entry.comp_1932(), (class_8786<T>) entry));
            }
            return byId;
        });
    }
}