package net.darkhax.bookshelf.common.api.entity.villager.trades;

import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_9306;

/**
 * A simple villager trade entry that represents an item being sold to the player.
 *
 * @param itemToBuy       The item being sold by the villager.
 * @param emeraldCost     The amount of emeralds the trade will cost.
 * @param maxUses         The amount of times the trade can be performed before a restocking is required.
 * @param villagerXp      The amount of villager XP to award for performing the trade.
 * @param priceMultiplier A price multiplier.
 */
public record VillagerSells(Supplier<class_1799> itemToBuy, int emeraldCost, int maxUses, int villagerXp, float priceMultiplier) implements class_3853.class_1652 {

    @Override
    public class_1914 method_7246(@NotNull class_1297 villager, @NotNull class_5819 rng) {
        return new class_1914(new class_9306(class_1802.field_8687, this.emeraldCost), this.itemToBuy.get(), this.maxUses, this.villagerXp, this.priceMultiplier);
    }
}