package net.darkhax.bookshelf.common.api.data.enchantment;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.ToIntBiFunction;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9304;

/**
 * Calculates enchantment levels using different methods.
 */
public enum EnchantmentLevel {

    /**
     * Returns the highest level among all matching enchantments.
     */
    HIGHEST((tag, enchantments) -> {
        int level = 0;
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
            if (entry.getKey().method_40220(tag) && entry.getIntValue() > level) {
                level = entry.getIntValue();
            }
        }
        return level;
    }),

    /**
     * Returns the lowest level among all matching enchantments.
     */
    LOWEST((tag, enchantments) -> {
        int level = Integer.MAX_VALUE;
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
            if (entry.getKey().method_40220(tag) && entry.getIntValue() < level) {
                level = entry.getIntValue();
            }
        }
        return level;
    }),

    /**
     * Returns the level of the first matching enchantment.
     */
    FIRST((tag, enchantments) -> {
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
            if (entry.getKey().method_40220(tag)) {
                return entry.getIntValue();
            }
        }
        return 0;
    }),

    /**
     * Returns the combined level of all matching enchantments.
     */
    CUMULATIVE((tag, enchantments) -> {
        int level = 0;
        for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
            if (entry.getKey().method_40220(tag)) {
                level += entry.getIntValue();
            }
        }
        return level;
    });

    private final ToIntBiFunction<class_6862<class_1887>, class_9304> func;

    EnchantmentLevel(ToIntBiFunction<class_6862<class_1887>, class_9304> func) {
        this.func = func;
    }

    /**
     * Gets the level of matching enchantments based on the calculation type.
     *
     * @param enchType A tag of the enchantments to match on.
     * @param stack    The item to test.
     * @return The level based on the calculation type.
     */
    public int get(class_6862<class_1887> enchType, class_1799 stack) {
        return (!stack.method_7960() && stack.method_7942()) ? this.func.applyAsInt(enchType, stack.method_58657()) : 0;
    }
}