package net.darkhax.bookshelf.common.api.data.codecs.map;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.util.FunctionHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.*;
import org.joml.Vector3f;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

@SuppressWarnings("unused")
public class MapCodecs {

    // JAVA TYPES
    public static final MapCodecHelper<Boolean> BOOLEAN = new MapCodecHelper<>(Codec.BOOL);
    public static final MapCodecHelper<Byte> BYTE = new MapCodecHelper<>(Codec.BYTE);
    public static final MapCodecHelper<Short> SHORT = new MapCodecHelper<>(Codec.SHORT);
    public static final MapCodecHelper<Integer> INT = new MapCodecHelper<>(Codec.INT);
    public static final MapCodecHelper<Float> FLOAT = new MapCodecHelper<>(Codec.FLOAT);
    public static final MapCodecHelper<Long> LONG = new MapCodecHelper<>(Codec.LONG);
    public static final MapCodecHelper<Double> DOUBLE = new MapCodecHelper<>(Codec.DOUBLE);
    public static final MapCodecHelper<String> STRING = new MapCodecHelper<>(Codec.STRING);
    public static final MapCodecHelper<UUID> UUID = new MapCodecHelper<>(class_4844.field_25122);

    // REGISTRIES
    public static final MapCodecHelper<class_6880<class_5712>> GAME_EVENT = RegistryMapCodecHelper.create(class_7923.field_41171);
    public static final MapCodecHelper<class_6880<class_3414>> SOUND_EVENT = RegistryMapCodecHelper.create(class_7923.field_41172);
    public static final MapCodecHelper<class_6880<class_3611>> FLUID = RegistryMapCodecHelper.create(class_7923.field_41173);
    public static final MapCodecHelper<class_6880<class_1291>> MOB_EFFECT = RegistryMapCodecHelper.create(class_7923.field_41174);
    public static final MapCodecHelper<class_6880<class_2248>> BLOCK = RegistryMapCodecHelper.create(class_7923.field_41175);
    public static final MapCodecHelper<class_6880<class_1299<?>>> ENTITY_TYPE = RegistryMapCodecHelper.create(class_7923.field_41177);
    public static final MapCodecHelper<class_6880<class_1792>> ITEM = RegistryMapCodecHelper.create(class_7923.field_41178);
    public static final MapCodecHelper<class_6880<class_1842>> POTION = RegistryMapCodecHelper.create(class_7923.field_41179);
    public static final MapCodecHelper<class_6880<class_2396<?>>> PARTICLE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41180);
    public static final MapCodecHelper<class_6880<class_2591<?>>> BLOCK_ENTITY_TYPE = RegistryMapCodecHelper.create(class_7923.field_41181);
    public static final MapCodecHelper<class_6880<class_2960>> CUSTOM_STAT = RegistryMapCodecHelper.create(class_7923.field_41183);
    public static final MapCodecHelper<class_6880<class_2806>> CHUNK_STATUS = RegistryMapCodecHelper.create(class_7923.field_41184);
    public static final MapCodecHelper<class_6880<class_3827<?>>> RULE_TEST = RegistryMapCodecHelper.create(class_7923.field_41185);
    public static final MapCodecHelper<class_6880<class_8249<?>>> RULE_BLOCK_ENTITY_MODIFIER = RegistryMapCodecHelper.create(class_7923.field_43381);
    public static final MapCodecHelper<class_6880<class_4996<?>>> POS_RULE_TEST = RegistryMapCodecHelper.create(class_7923.field_41186);
    public static final MapCodecHelper<class_6880<class_3917<?>>> MENU = RegistryMapCodecHelper.create(class_7923.field_41187);
    public static final MapCodecHelper<class_6880<class_3956<?>>> RECIPE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41188);
    public static final MapCodecHelper<class_6880<class_1865<?>>> RECIPE_SERIALIZER = RegistryMapCodecHelper.create(class_7923.field_41189);
    public static final MapCodecHelper<class_6880<class_1320>> ATTRIBUTE = RegistryMapCodecHelper.create(class_7923.field_41190);
    public static final MapCodecHelper<class_6880<class_5717<?>>> POSITION_SOURCE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41191);
    public static final MapCodecHelper<class_6880<class_2314<?, ?>>> COMMAND_ARGUMENT_TYPE = RegistryMapCodecHelper.create(class_7923.field_41192);
    public static final MapCodecHelper<class_6880<class_3448<?>>> STAT_TYPE = RegistryMapCodecHelper.create(class_7923.field_41193);
    public static final MapCodecHelper<class_6880<class_3854>> VILLAGER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41194);
    public static final MapCodecHelper<class_6880<class_3852>> VILLAGER_PROFESSION = RegistryMapCodecHelper.create(class_7923.field_41195);
    public static final MapCodecHelper<class_6880<class_4158>> POINT_OF_INTEREST_TYPE = RegistryMapCodecHelper.create(class_7923.field_41128);
    public static final MapCodecHelper<class_6880<class_4140<?>>> MEMORY_MODULE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41129);
    public static final MapCodecHelper<class_6880<class_4149<?>>> SENSOR_TYPE = RegistryMapCodecHelper.create(class_7923.field_41130);
    public static final MapCodecHelper<class_6880<class_4170>> SCHEDULE = RegistryMapCodecHelper.create(class_7923.field_41131);
    public static final MapCodecHelper<class_6880<class_4168>> ACTIVITY = RegistryMapCodecHelper.create(class_7923.field_41132);
    public static final MapCodecHelper<class_6880<class_5338>> LOOT_POOL_ENTRY_TYPE = RegistryMapCodecHelper.create(class_7923.field_41133);
    public static final MapCodecHelper<class_6880<class_5339<?>>> LOOT_FUNCTION_TYPE = RegistryMapCodecHelper.create(class_7923.field_41134);
    public static final MapCodecHelper<class_6880<class_5342>> LOOT_CONDITION_TYPE = RegistryMapCodecHelper.create(class_7923.field_41135);
    public static final MapCodecHelper<class_6880<class_5657>> LOOT_NUMBER_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41136);
    public static final MapCodecHelper<class_6880<class_5650>> LOOT_NBT_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41137);
    public static final MapCodecHelper<class_6880<class_5669>> LOOT_SCORE_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41138);
    public static final MapCodecHelper<class_6880<class_5864<?>>> FLOAT_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41139);
    public static final MapCodecHelper<class_6880<class_6018<?>>> INT_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41140);
    public static final MapCodecHelper<class_6880<class_6123<?>>> HEIGHT_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41141);
    public static final MapCodecHelper<class_6880<class_6647<?>>> BLOCK_PREDICATE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41142);
    public static final MapCodecHelper<class_6880<class_2939<?>>> CARVER = RegistryMapCodecHelper.create(class_7923.field_41143);
    public static final MapCodecHelper<class_6880<class_3031<?>>> FEATURE = RegistryMapCodecHelper.create(class_7923.field_41144);
    public static final MapCodecHelper<class_6880<class_6875<?>>> STRUCTURE_PLACEMENT = RegistryMapCodecHelper.create(class_7923.field_41145);
    public static final MapCodecHelper<class_6880<class_3773>> STRUCTURE_PIECE = RegistryMapCodecHelper.create(class_7923.field_41146);
    public static final MapCodecHelper<class_6880<class_7151<?>>> STRUCTURE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41147);
    public static final MapCodecHelper<class_6880<class_6798<?>>> PLACEMENT_MODIFIER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41148);
    public static final MapCodecHelper<class_6880<class_4652<?>>> BLOCKSTATE_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41149);
    public static final MapCodecHelper<class_6880<class_4648<?>>> FOLIAGE_PLACER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41150);
    public static final MapCodecHelper<class_6880<class_5142<?>>> TRUNK_PLACER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41151);
    public static final MapCodecHelper<class_6880<class_7388<?>>> ROOT_PLACER_TYPE = RegistryMapCodecHelper.create(class_7923.field_41152);
    public static final MapCodecHelper<class_6880<class_4663<?>>> TREE_DECORATOR_TYPE = RegistryMapCodecHelper.create(class_7923.field_41153);
    public static final MapCodecHelper<class_6880<class_5202<?>>> FEATURE_SIZE_TYPE = RegistryMapCodecHelper.create(class_7923.field_41155);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_1966>>> BIOME_SOURCE = RegistryMapCodecHelper.create(class_7923.field_41156);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_2794>>> CHUNK_GENERATOR = RegistryMapCodecHelper.create(class_7923.field_41157);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_6686.class_6693>>> MATERIAL_CONDITION = RegistryMapCodecHelper.create(class_7923.field_41158);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_6686.class_6708>>> MATERIAL_RULE = RegistryMapCodecHelper.create(class_7923.field_41159);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_6910>>> DENSITY_FUNCTION_TYPE = RegistryMapCodecHelper.create(class_7923.field_41160);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_2248>>> BLOCK_TYPE = RegistryMapCodecHelper.create(class_7923.field_46591);
    public static final MapCodecHelper<class_6880<class_3828<?>>> STRUCTURE_PROCESSOR = RegistryMapCodecHelper.create(class_7923.field_41161);
    public static final MapCodecHelper<class_6880<class_3816<?>>> STRUCTURE_POOL_ELEMENT = RegistryMapCodecHelper.create(class_7923.field_41162);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_8889>>> POOL_ALIAS_BINDING_TYPE = RegistryMapCodecHelper.create(class_7923.field_46912);
    public static final MapCodecHelper<class_6880<class_7375>> CAT_VARIANT = RegistryMapCodecHelper.create(class_7923.field_41163);
    public static final MapCodecHelper<class_6880<class_7106>> FROG_VARIANT = RegistryMapCodecHelper.create(class_7923.field_41164);
    public static final MapCodecHelper<class_6880<class_7444>> INSTRUMENT = RegistryMapCodecHelper.create(class_7923.field_41166);
    public static final MapCodecHelper<class_6880<class_9766>> DECORATED_POT_PATTERN = RegistryMapCodecHelper.create(class_7923.field_42940);
    public static final MapCodecHelper<class_6880<class_1761>> CREATIVE_MODE_TAB = RegistryMapCodecHelper.create(class_7923.field_44687);
    public static final MapCodecHelper<class_6880<class_179<?>>> TRIGGER_TYPES = RegistryMapCodecHelper.create(class_7923.field_47496);
    public static final MapCodecHelper<class_6880<class_9023<?>>> NUMBER_FORMAT_TYPE = RegistryMapCodecHelper.create(class_7923.field_47555);
    public static final MapCodecHelper<class_6880<class_1741>> ARMOR_MATERIAL = RegistryMapCodecHelper.create(class_7923.field_48976);
    public static final MapCodecHelper<class_6880<class_9331<?>>> DATA_COMPONENT_TYPE = RegistryMapCodecHelper.create(class_7923.field_49658);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_7376>>> ENTITY_SUB_PREDICATE_TYPE = RegistryMapCodecHelper.create(class_7923.field_49911);
    public static final MapCodecHelper<class_6880<class_9360.class_8745<?>>> ITEM_SUB_PREDICATE_TYPE = RegistryMapCodecHelper.create(class_7923.field_49912);
    public static final MapCodecHelper<class_6880<class_9428>> MAP_DECORATION_TYPE = RegistryMapCodecHelper.create(class_7923.field_50078);
    public static final MapCodecHelper<class_6880<class_9331<?>>> ENCHANTMENT_EFFECT_COMPONENT_TYPE = RegistryMapCodecHelper.create(class_7923.field_51832);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_9704>>> ENCHANTMENT_LEVEL_BASED_VALUE_TYPE = RegistryMapCodecHelper.create(class_7923.field_51833);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_9721>>> ENCHANTMENT_ENTITY_EFFECT_TYPE = RegistryMapCodecHelper.create(class_7923.field_51834);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_9722>>> ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE = RegistryMapCodecHelper.create(class_7923.field_51835);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_9723>>> ENCHANTMENT_VALUE_EFFECT_TYPE = RegistryMapCodecHelper.create(class_7923.field_51836);
    public static final MapCodecHelper<class_6880<MapCodec<? extends class_9741>>> ENCHANTMENT_PROVIDER_TYPE = RegistryMapCodecHelper.create(class_7923.field_51837);

    // ENUMS
    public static final MapCodecHelper<class_1814> ITEM_RARITY = new MapCodecHelper<>(enumerable(class_1814.class));
    public static final MapCodecHelper<class_1322.class_1323> ATTRIBUTE_OPERATION = new MapCodecHelper<>(class_1322.class_1323.field_45742);
    public static final MapCodecHelper<class_2350> DIRECTION = new MapCodecHelper<>(enumerable(class_2350.class));
    public static final MapCodecHelper<class_2350.class_2351> AXIS = new MapCodecHelper<>(enumerable(class_2350.class_2351.class));
    public static final MapCodecHelper<class_2350.class_2353> PLANE = new MapCodecHelper<>(enumerable(class_2350.class_2353.class));
    public static final MapCodecHelper<class_1311> MOB_CATEGORY = new MapCodecHelper<>(enumerable(class_1311.class));
    public static final MapCodecHelper<class_1767> DYE_COLOR = new MapCodecHelper<>(enumerable(class_1767.class));
    public static final MapCodecHelper<class_3419> SOUND_SOURCE = new MapCodecHelper<>(enumerable(class_3419.class));
    public static final MapCodecHelper<class_1267> DIFFICULTY = new MapCodecHelper<>(enumerable(class_1267.class));
    public static final MapCodecHelper<class_1304> EQUIPMENT_SLOT = new MapCodecHelper<>(enumerable(class_1304.class));
    public static final MapCodecHelper<class_2415> MIRROR = new MapCodecHelper<>(enumerable(class_2415.class));
    public static final MapCodecHelper<class_2470> ROTATION = new MapCodecHelper<>(enumerable(class_2470.class));

    // MINECRAFT TYPES
    public static final MapCodecHelper<class_2960> RESOURCE_LOCATION = new MapCodecHelper<>(class_2960.field_25139);
    public static final MapCodecHelper<class_2487> COMPOUND_TAG = new MapCodecHelper<>(class_2487.field_25128);
    public static final MapCodecHelper<class_1799> ITEM_STACK = new MapCodecHelper<>(class_1799.field_24671);
    public static final MapCodecHelper<class_1799> ITEM_STACK_STRICT = new MapCodecHelper<>(class_1799.field_51397);
    public static final MapCodecHelper<class_2561> TEXT = new MapCodecHelper<>(class_8824.field_46597);
    public static final MapCodecHelper<class_2338> BLOCK_POS = new MapCodecHelper<>(class_2338.field_25064);
    public static final MapCodecHelper<class_1856> INGREDIENT = new MapCodecHelper<>(class_1856.field_46095);
    public static final MapCodecHelper<class_1856> INGREDIENT_NONEMPTY = new MapCodecHelper<>(class_1856.field_46096);
    public static final MapCodec<class_2680> BLOCK_STATE_MAP_CODEC = Codec.mapPair(BLOCK.get().fieldOf("block"), Codec.unboundedMap(Codec.STRING, Codec.STRING).optionalFieldOf("properties")).flatXmap(MapCodecs::decodeBlockState, MapCodecs::encodeBlockState);
    public static final MapCodecHelper<class_2680> BLOCK_STATE = new MapCodecHelper<>(BLOCK_STATE_MAP_CODEC.codec());
    public static final MapCodecHelper<class_1322> ATTRIBUTE_MODIFIER = new MapCodecHelper<>(class_1322.field_46247);
    public static final MapCodecHelper<class_1293> EFFECT_INSTANCE = new MapCodecHelper<>(class_1293.field_48821);
    public static final MapCodecHelper<Vector3f> VECTOR_3F = new MapCodecHelper<>(class_5699.field_40723);

    // Bookshelf Types
    public static final MapCodecHelper<ILoadCondition> LOAD_CONDITION = LoadConditions.CODEC_HELPER;

    /**
     * Creates a Codec that can flexibly read individual values as a list in addition to traditional lists.
     *
     * @param codec The codec for reading an individual value.
     * @param <T>   The type of value handled by the codec.
     * @return A Codec that can flexibly read individual values as a list in addition to traditional lists.
     */
    public static <T> Codec<List<T>> flexibleList(Codec<T> codec) {

        return Codec.either(codec.listOf(), codec).xmap(either -> either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right(list.getFirst()) : Either.left(list));
    }

    /**
     * Creates a Codec that can flexibly read both individual values and arrays of values as a set.
     *
     * @param codec The Codec for reading an individual value.
     * @param <T>   The type of value handled by the codec.
     * @return A Codec that can flexibly read both individual values and arrays of values as a set.
     */
    public static <T> Codec<Set<T>> flexibleSet(Codec<T> codec) {

        return flexibleList(codec).xmap(LinkedHashSet::new, ArrayList::new);
    }

    /**
     * Creates a Codec that can flexibly read both individual values and arrays of values as an array.
     *
     * @param codec        The Codec for reading an individual value.
     * @param arrayBuilder A function that creates new arrays of the required type. The function is given the size of
     *                     the list.
     * @param <T>          The type of value handled by the codec.
     * @return A Codec that can flexibly read both individual values and arrays of values as an array.
     */
    public static <T> Codec<T[]> flexibleArray(Codec<T> codec, IntFunction<T[]> arrayBuilder) {

        return flexibleList(codec).xmap(list -> list.toArray(arrayBuilder.apply(list.size())), List::of);
    }

    /**
     * Creates a Codec that will use a fallback value if no other value is specified. This is different from
     * {@link Codec#optionalFieldOf(String, Object)} in that the fallback value is provided by a supplier.
     *
     * @param codec            The base Codec to use.
     * @param name             The name of the field to read from.
     * @param fallbackSupplier A supplier that produces the default value. You should probably memoize this.
     * @param <T>              The type of value handled by the codec.
     * @return A Codec that will use a fallback value if the field is not specified.
     */
    public static <T> MapCodec<T> fallback(Codec<T> codec, String name, Supplier<T> fallbackSupplier) {

        return fallback(codec, name, fallbackSupplier, true);
    }

    /**
     * Creates a Codec that handles optional values. This is different from
     * {@link Codec#optionalFieldOf(String, Object)} in that it keeps the type as an Optional.
     *
     * @param codec         The base Codec to use.
     * @param name          The name of the field to read from.
     * @param fallback      The fallback optional value.
     * @param writesDefault Should the default value be written or left blank?
     * @param <T>           The type of the optional value handled by the coded.
     * @return A Codec that handles optional values.
     */
    public static <T> MapCodec<Optional<T>> optional(Codec<T> codec, String name, Optional<T> fallback, boolean writesDefault) {

        return Codec.optionalField(name, codec, false).xmap(o -> o.isPresent() ? o : fallback, a -> a.isEmpty() || (Objects.equals(a.get(), fallback.orElse(null)) && !writesDefault) ? Optional.empty() : a);
    }

    /**
     * Creates a Codec that can handle nullable values.
     *
     * @param codec     The base Codec to use.
     * @param fieldName The name of the field to read from.
     * @param <T>       The type of value handled by the codec.
     * @return A Codec that handles nullable values.
     */
    public static <T> MapCodec<T> nullable(Codec<T> codec, String fieldName) {

        return Codec.optionalField(fieldName, codec, false).xmap(optional -> optional.orElse(null), Optional::ofNullable);
    }

    /**
     * Creates a Codec that will use a fallback value if no other value is specified. This is different from
     * {@link Codec#optionalFieldOf(String, Object)} in that the fallback value is provided by a supplier. It also
     * allows you to control if the default value should be written when or left blank.
     *
     * @param codec            The base Codec to use.
     * @param name             The name of the field to read from.
     * @param fallbackSupplier A supplier that produces the default value. You should probably memoize this.
     * @param writesDefault    Should the default value be written or left blank?
     * @param <T>              The type of value handled by the codec.
     * @return A Codec that will use a fallback value if the field is not specified.
     */
    public static <T> MapCodec<T> fallback(Codec<T> codec, String name, Supplier<T> fallbackSupplier, boolean writesDefault) {

        return Codec.optionalField(name, codec, false).xmap(value -> value.orElse(fallbackSupplier.get()), value -> {
            final T fallback = fallbackSupplier.get();
            return Objects.equals(value, fallback) && !writesDefault ? Optional.empty() : Optional.of(value);
        });
    }

    private static <T extends Enum<T>> Map<String, T> getEnumsByName(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalStateException("Class " + enumClass.getCanonicalName() + " is not an enum!");
        }
        final Map<String, T> valueMap = new HashMap<>();
        for (T value : enumClass.getEnumConstants()) {
            final String name = value.name();
            if (valueMap.containsKey(name)) {
                Constants.LOG.error("Duplicate name '{}' found in enum '{}'. Another mod is doing something very wrong. old='{}' new='{}'", name, enumClass.getName(), valueMap.get(name), value);
            }
            valueMap.put(name, value);
        }
        return valueMap;
    }

    /**
     * Creates a Codec that handles enum values by using their enum constant names.
     * <br>
     * If the codec can not read an enum value from the provided name it will try again using an all uppercase version
     * of the input. This allows users to write values in all lowercase which may feel more natural for some users and
     * adds extra flexibility.
     * <br>
     * If the codec can not read any enum value from the provided name it will create an error. The error message will
     * try to help the user by recommending a nearby match and including all possible values.
     *
     * @param enumClass The class of the enum to get values for.
     * @param <T>       The type of the enum.
     * @return A codec that can read and write enum values using their enum constant name.
     */
    public static <T extends Enum<T>> Codec<T> enumerable(Class<T> enumClass) {
        final Map<String, T> enumValues = getEnumsByName(enumClass);
        final Function<String, T> fromString = name -> {
            T value = enumValues.get(name);
            if (value == null) {
                value = enumValues.get(name.toUpperCase(Locale.ROOT));
            }
            return value;
        };
        final UnaryOperator<String> errorMessage = name -> {
            final StringJoiner message = new StringJoiner(" ");
            message.add("Unable to find " + enumClass.getSimpleName() + " entry \"" + name + "\".");
            final Set<String> similarMatches = TextHelper.getPossibleMatches(name, enumValues.keySet(), 2);
            if (!similarMatches.isEmpty()) {
                message.add("Did you mean \"" + similarMatches.stream().findFirst().get() + "\"?");
            }
            message.add("Available Options are " + TextHelper.formatCollection(enumValues.keySet()));
            return message.toString();
        };
        return Codec.STRING.flatXmap(string -> class_8144.method_49079(fromString.apply(string), DataResult::success, () -> DataResult.error(() -> errorMessage.apply(string))), object -> DataResult.success(object.name()));
    }

    // INTERNAL HELPERS
    @SuppressWarnings({"rawtypes", "unchecked"})
    private static DataResult<class_2680> decodeBlockState(Pair<class_6880<class_2248>, Optional<Map<String, String>>> props) {

        final class_2248 block = props.getFirst().comp_349();
        final Map<String, String> properties = props.getSecond().orElse(new HashMap<>());
        class_2680 state = block.method_9564();

        if (!properties.isEmpty()) {

            final class_2689<class_2248, class_2680> definition = block.method_9595();

            for (Map.Entry<String, String> entry : properties.entrySet()) {

                final class_2769<? extends Comparable<?>> property = definition.method_11663(entry.getKey());

                if (property != null) {

                    final Optional<?> value = property.method_11900(entry.getValue());

                    if (value.isPresent()) {

                        try {

                            state = state.method_11657((class_2769) property, (Comparable) value.get());
                        }

                        catch (final Exception e) {

                            Constants.LOG.error("Failed to update state for block {} with valid value {}={}. The mod that adds this block may have a serious issue.", class_7923.field_41175.method_10221(block), entry.getKey(), entry.getValue());
                            return DataResult.error(e::getMessage);
                        }
                    }

                    else {

                        return DataResult.error(() -> "\"" + entry.getValue() + "\" is not a valid value for property \"" + property.method_11899() + "\" on block \"" + class_7923.field_41175.method_10221(block) + "\". Available values: " + property.method_30043().map(propVal -> ((class_2769) property).method_11901(propVal.comp_71())).collect(Collectors.joining()));
                    }
                }

                else {

                    return DataResult.error(() -> "The property \"" + entry.getKey() + "\" is not valid for block \"" + class_7923.field_41175.method_10221(block) + "\". Available properties: " + definition.method_11659().stream().map(class_2769::method_11899).collect(Collectors.joining()));
                }
            }
        }

        return DataResult.success(state);
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    private static DataResult<Pair<class_6880<class_2248>, Optional<Map<String, String>>>> encodeBlockState(class_2680 state) {

        final Map<String, String> propertyMap = new HashMap<>();

        for (Map.Entry<class_2769<?>, Comparable<?>> entry : state.method_11656().entrySet()) {

            propertyMap.put(entry.getKey().method_11899(), ((class_2769) entry.getKey()).method_11901(entry.getValue()));
        }

        return DataResult.success(new Pair<>(state.method_26204().method_40142(), Optional.ofNullable(propertyMap.isEmpty() ? null : propertyMap)));
    }

    /**
     * Creates a codec that will try two different codecs, using the first valid codec. Encoding will always use the
     * first codec.
     *
     * @param first  The first codec to try when decoding. This will be the only codec used in encoding.
     * @param second The second codec to try when decoding.
     * @param <T>    The type of codec to create.
     * @return A codec that will try two different codecs.
     */
    public static <T> Codec<T> xor(Codec<T> first, Codec<T> second) {
        return Codec.xor(first, second).xmap(FunctionHelper::unpack, Either::left);
    }
}