package net.darkhax.bookshelf.common.api.commands;

import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public enum PermissionLevel implements Predicate<class_2168> {

    /**
     * All players will generally meet the requirements for this permission level.
     */
    PLAYER(class_2170.field_31837),

    /**
     * These players have slightly elevated permission levels. In vanilla, they do not gain access to any additional
     * commands, but they are able to bypass spawn chunk protection.
     */
    MODERATOR(class_2170.field_31838),

    /**
     * These players can execute commands that modify the world and player data. They are also allowed to use and modify
     * command blocks.
     */
    GAMEMASTER(class_2170.field_31839),

    /**
     * These players can use commands related to player management. For example, they can ban, kick, op, and de-op.
     */
    ADMIN(class_2170.field_31840),

    /**
     * This is the highest permission level available in vanilla Minecraft. Players with this permission level generally
     * have no restrictions.
     */
    OWNER(class_2170.field_31841);

    final int level;

    PermissionLevel(int level) {
        this.level = level;
    }

    public int get() {
        return this.level;
    }

    @Override
    public boolean test(class_2168 source) {
        return source.method_9259(this.level);
    }
}
