package net.darkhax.bookshelf.common.mixin.patch.advancement;

import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import net.minecraft.class_9360;
import net.minecraft.class_9361;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_9361.class)
public class MixinItemSubPredicates {

    @Inject(method = "bootstrap(Lnet/minecraft/core/Registry;)Lnet/minecraft/advancements/critereon/ItemSubPredicate$Type;", at = @At("RETURN"))
    private static void onBootstrap(class_2378<class_9360.class_8745<?>> registry, CallbackInfoReturnable<class_9360.class_8745<?>> cir) {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            final String owner = provider.contentNamespace();
            provider.registerItemSubPredicates(new Register<>(owner, (id, predicate) -> class_2378.method_10230(class_7923.field_49912, id, predicate)));
        });
    }
}