package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;

public class EnchantCommand {

    public static LiteralArgumentBuilder<class_2168> build(class_7157 context) {
        final LiteralArgumentBuilder<class_2168> root = class_2170.method_9247("enchant").requires(PermissionLevel.GAMEMASTER);
        root.then(class_2170.method_9244("enchantment", class_7733.method_45603(context, class_7924.field_41265)).then(class_2170.method_9244("level", IntegerArgumentType.integer(0)).executes(EnchantCommand::enchantItem)));
        root.then(class_2170.method_9244("target", class_2186.method_9309()).then(class_2170.method_9244("enchantment", class_7733.method_45603(context, class_7924.field_41265)).then(class_2170.method_9244("level", IntegerArgumentType.integer(0)).executes(EnchantCommand::enchantItem))));
        return root;
    }

    private static int enchantItem(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        final class_1297 target = CommandHelper.getEntityOrSender("target", ctx);
        final class_6880.class_6883<class_1887> enchantment = class_7733.method_45612(ctx, "enchantment");
        final int level = IntegerArgumentType.getInteger(ctx, "level");
        if (target instanceof class_1309 livingTarget) {
            if (livingTarget.method_6047().method_7960()) {
                ctx.getSource().method_9213(class_2561.method_43471("commands.bookshelf.hand.error.not_air"));
                return 0;
            }
            livingTarget.method_6047().method_7978(enchantment, level);
            return Command.SINGLE_SUCCESS;
        }
        return 0;
    }
}