package net.darkhax.bookshelf.common.api.text.font;

import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public interface IFontEntry {

    /**
     * Gets the ID of the font.
     *
     * @return The font ID.
     */
    class_2960 identifier();

    /**
     * Gets the localized name of the font.
     *
     * @return The localized name of the font.
     */
    default class_5250 displayName() {
        return TextHelper.fromResourceLocation("font", null, this.identifier());
    }

    /**
     * Gets a description of the font.
     *
     * @return A description of the font.
     */
    default class_5250 description() {
        return TextHelper.fromResourceLocation("font", "desc", this.identifier());
    }

    /**
     * Gets some text that can be used as a preview for the font in-game.
     *
     * @return The preview text for the font.
     */
    default class_5250 preview() {
        return TextHelper.fromResourceLocation("font", "preview", this.identifier());
    }
}