package net.darkhax.bookshelf.common.api.registry.register;

import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBlockEntityRenderers;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5614;
import java.util.function.BiConsumer;

@SuppressWarnings("rawtypes")
public record RegisterBlockEntityRenderer(BiConsumer<class_2591, class_5614> bindFunc) {

    public <T extends class_2586> void bind(class_2591<T> type, class_5614<T> rendererProvider) {
        this.bindFunc.accept(type, rendererProvider);
    }

    public static void bindBlockEntityRenderers() {
        final RegisterBlockEntityRenderer binder = new RegisterBlockEntityRenderer(AccessorBlockEntityRenderers::bookshelf$register);
        Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.bindBlockEntityRenderer(binder));
    }
}