/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.loot;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriber;
import net.darkhax.bookshelf.common.api.registry.register.RegisterLootDescription;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.data.loot.entries.LootItemStack;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorCompositeEntryBase;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootItem;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootPool;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootTable;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorNestedLootTable;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorTagEntry;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_55;
import net.minecraft.class_67;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_73;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class LootPoolEntryDescriptions {
    private static final CachedSupplier<List<class_1799>> UNKNOWN_ITEM_DISPLAY = CachedSupplier.cache(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8615);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"tooltips.bookshelf.loot.unknown"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43471((String)"tooltips.bookshelf.loot.unknown.desc").method_27692(class_124.field_1080))));
        return List.of(stack);
    });
    private static final CachedSupplier<List<class_1799>> EMPTY_ITEM_DISPLAY = CachedSupplier.cache(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8077);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"tooltips.bookshelf.loot.empty"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43471((String)"tooltips.bookshelf.loot.empty.desc").method_27692(class_124.field_1080))));
        return List.of(stack);
    });
    private static final CachedSupplier<List<class_1799>> DYNAMIC_DISPLAY = CachedSupplier.cache(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_16538);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"tooltips.bookshelf.loot.dynamic"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43471((String)"tooltips.bookshelf.loot.dynamic.desc").method_27692(class_124.field_1080))));
        return List.of(stack);
    });
    private static final Map<class_5338, LootPoolEntryDescriber> DESCRIBERS = new HashMap<class_5338, LootPoolEntryDescriber>();
    private static boolean hasInitialized = false;
    public static final LootPoolEntryDescriber EMPTY = (server, entry) -> Optional.ofNullable(entry instanceof class_73 ? EMPTY_ITEM_DISPLAY.get() : null);
    public static final LootPoolEntryDescriber ITEM = (server, entry) -> {
        List<class_1799> list;
        if (entry instanceof AccessorLootItem) {
            AccessorLootItem accessor = (AccessorLootItem)entry;
            list = List.of(new class_1799(accessor.bookshelf$item()));
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber LOOT_TABLE = (server, entry) -> {
        List<class_1799> list;
        if (entry instanceof AccessorNestedLootTable) {
            AccessorNestedLootTable accessor = (AccessorNestedLootTable)entry;
            list = LootPoolEntryDescriptions.getPotentialItems(server, accessor.bookshelf$contents());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber DYNAMIC = (server, entry) -> Optional.ofNullable(entry instanceof class_67 ? DYNAMIC_DISPLAY.get() : null);
    public static final LootPoolEntryDescriber TAG = (server, entry) -> {
        List<class_1799> list;
        if (entry instanceof AccessorTagEntry) {
            AccessorTagEntry tagEntry = (AccessorTagEntry)entry;
            list = LootPoolEntryDescriptions.getTagItems(tagEntry.bookshelf$tag());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber COMPOSITE = (server, entry) -> {
        List<class_1799> list;
        if (entry instanceof AccessorCompositeEntryBase) {
            AccessorCompositeEntryBase access = (AccessorCompositeEntryBase)entry;
            list = LootPoolEntryDescriptions.getPotentialItems(server, access.bookshelf$children());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber ITEM_STACK = (server, entry) -> {
        List<class_1799> list;
        if (entry instanceof LootItemStack) {
            LootItemStack loot = (LootItemStack)entry;
            list = List.of(loot.getBaseStack());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };

    private static void bootstrap() {
        if (!hasInitialized) {
            RegisterLootDescription register = new RegisterLootDescription(DESCRIBERS::put);
            Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerLootDescriptions(register));
            hasInitialized = true;
        }
    }

    public static List<class_1799> getPotentialItems(MinecraftServer server, Either<class_5321<class_52>, class_52> table) {
        class_52 resolved = (class_52)table.map(key -> server.method_58576().method_58295(key), Function.identity());
        return resolved == null ? List.of() : LootPoolEntryDescriptions.getPotentialItems(server, resolved);
    }

    public static List<class_1799> getPotentialItems(MinecraftServer server, class_52 table) {
        class_2371 items = class_2371.method_10211();
        if (table instanceof AccessorLootTable) {
            AccessorLootTable tableAccess = (AccessorLootTable)table;
            for (class_55 pool : tableAccess.bookshelf$pools()) {
                if (!(pool instanceof AccessorLootPool)) continue;
                AccessorLootPool poolAccess = (AccessorLootPool)pool;
                LootPoolEntryDescriptions.getPotentialItems(server, poolAccess.bookshelf$entries()).forEach(arg_0 -> LootPoolEntryDescriptions.lambda$getPotentialItems$12((List)items, arg_0));
            }
        }
        return items;
    }

    public static List<class_1799> getPotentialItems(MinecraftServer server, List<class_79> entries) {
        class_2371 items = class_2371.method_10211();
        for (class_79 entry : entries) {
            items.addAll(LootPoolEntryDescriptions.getPotentialItems(server, entry));
        }
        return items;
    }

    public static List<class_1799> getPotentialItems(MinecraftServer server, class_79 entry) {
        LootPoolEntryDescriptions.bootstrap();
        LootPoolEntryDescriber describer = DESCRIBERS.get(entry.method_29318());
        return describer != null ? describer.getPotentialDrops(server, entry).orElse(UNKNOWN_ITEM_DISPLAY.get()) : UNKNOWN_ITEM_DISPLAY.get();
    }

    private static void addStacking(List<class_1799> items, class_1799 toAdd) {
        for (class_1799 existing : items) {
            if (!Objects.equals(existing, toAdd) && !class_1799.method_31577((class_1799)existing, (class_1799)toAdd)) continue;
            return;
        }
        items.add(toAdd);
    }

    private static List<class_1799> getTagItems(class_6862<class_1792> tag) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_6880 item : class_7923.field_41178.method_40286(tag)) {
            items.add(new class_1799(item));
        }
        return items;
    }

    private static /* synthetic */ void lambda$getPotentialItems$12(List items, class_1799 stack) {
        LootPoolEntryDescriptions.addStacking(items, stack);
    }
}

