package net.darkhax.bookshelf.fabric.impl.util;

import net.darkhax.bookshelf.common.api.ModEntry;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.util.IPlatformHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.impl.gametest.FabricGameTestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1703;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FabricPlatformHelper implements IPlatformHelper {

    private static final Supplier<Set<ModEntry>> LOADED_MODS = CachedSupplier.cache(() -> FabricLoader.getInstance().getAllMods().stream().map(mod -> {
        final ModMetadata meta = mod.getMetadata();
        return new ModEntry(meta.getId(), meta.getName(), meta.getDescription(), meta.getVersion().getFriendlyString());
    }).collect(Collectors.toSet()));

    @Override
    public Path getGamePath() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public Path getModsPath() {
        return this.getGamePath().resolve("mods");
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public PhysicalSide getPhysicalSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? PhysicalSide.CLIENT : PhysicalSide.SERVER;
    }

    @Override
    public Set<ModEntry> getLoadedMods() {
        return LOADED_MODS.get();
    }

    @Override
    public boolean isTestingEnvironment() {
        return FabricGameTestHelper.ENABLED;
    }

    @Override
    public String getName() {
        return "Fabric";
    }

    @Override
    public <T extends class_1703> void unsafeRegisterMenu(class_2960 id, MenuRegister.ClientMenuFactory<T> clientFactory) {
        class_2378.method_10230(class_7923.field_41187, id, new class_3917<>(clientFactory::create, class_7701.field_40182));
    }
}