package net.darkhax.bookshelf.fabric.impl.util;

import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.darkhax.bookshelf.common.api.util.IGameplayHelper;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import java.util.function.BiFunction;

public class FabricGameplayHelper implements IGameplayHelper {

    @Override
    public class_1799 inventoryInsert(class_3218 level, class_2338 pos, class_2350 side, class_1799 stack) {
        final int initialCount = stack.method_7947();
        final class_1799 result = IGameplayHelper.super.inventoryInsert(level, pos, side, stack);
        if (result.method_7960() || result.method_7947() != initialCount) {
            return result;
        }
        final Storage<ItemVariant> storage = ItemStorage.SIDED.find(level, pos, side);
        if (storage != null && storage.supportsInsertion()) {
            try (Transaction tx = Transaction.openOuter()) {
                final long count = storage.insert(ItemVariant.of(stack), stack.method_7947(), tx);
                tx.commit();
                if (count >= stack.method_7947()) {
                    return class_1799.field_8037;
                }
                else {
                    final class_1799 txResult = stack.method_7972();
                    txResult.method_7934((int) count);
                    return txResult;
                }
            }
        }
        return stack;
    }

    @Override
    public <T extends class_2586> class_2591.class_2592<T> blockEntityBuilder(BiFunction<class_2338, class_2680, T> factory, class_2248... validBlocks) {
        class_2591.class_5559<T> supplier = factory::apply;
        return class_2591.class_2592.method_20528(supplier, validBlocks);
    }

    @Override
    public <M extends class_1703, U extends class_437 & class_3936<M>> void bindMenu(class_3917<? extends M> type, RegisterMenuScreen.ScreenFactory<M, U> factory) {
        final class_3929.class_3930<M, U> screenFactory = factory::create;
        class_3929.method_17542(type, screenFactory);
    }

    @Override
    public class_1761.class_7913 tabBuilder() {
        return FabricItemGroup.builder();
    }
}