package net.darkhax.bookshelf.common.mixin.patch.registries;

import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterPacket;
import net.darkhax.bookshelf.common.api.registry.register.RegisterParticleTypes;
import net.darkhax.bookshelf.common.api.registry.register.RegisterRecipeType;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.recipe.RecipeTypeImpl;
import net.darkhax.bookshelf.common.mixin.access.particles.AccessSimpleParticleType;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5342;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_7923.class)
public class MixinBuiltInRegistries {

    @Inject(method = "bootStrap()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/core/registries/BuiltInRegistries;freeze()V", ordinal = 0))
    private static void bootstrap(CallbackInfo callback) {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            final String owner = provider.contentNamespace();
            provider.registerMobEffects(new Register<>(owner, (id, effect) -> class_2378.method_47985(class_7923.field_41174, id, effect)));
            provider.registerBlocks(new Register<>(owner, (id, block) -> class_2246.method_52571(class_5321.method_29179(class_7923.field_41175.method_30517(), id), block)));
            provider.registerEntities(new Register<>(owner, (id, builder) -> class_2378.method_10230(class_7923.field_41177, id, builder.method_5905(id.toString()))));
            provider.registerItems(new Register<>(owner, class_1802::method_7990));
            provider.registerItems(new RegisterItem(owner, class_1802::method_7990));
            provider.registerBlockEntities(new Register<>(owner, (id, builder) -> class_2378.method_10230(class_7923.field_41181, id, builder.method_11034(null))));
            provider.registerMenus(new MenuRegister(owner));
            provider.registerRecipeTypes(new RegisterRecipeType(owner, id -> class_2378.method_10230(class_7923.field_41188, id, new RecipeTypeImpl<>(id))));
            provider.registerRecipeSerializers(new Register<>(owner, (id, serializer) -> class_2378.method_10230(class_7923.field_41189, id, serializer)));
            provider.registerAttributes(new Register<>(owner, (id, attribute) -> class_2378.method_10230(class_7923.field_41190, id, attribute)));
            provider.registerLootConditions(new Register<>(owner, (id, codec) -> class_2378.method_10230(class_7923.field_41135, id, new class_5342(codec))));
            provider.registerLootFunctions(new Register<>(owner, (id, codec) -> class_2378.method_10230(class_7923.field_41134, id, new class_5339<>(codec))));
            provider.registerLoadConditions(new Register<>(owner, LoadConditions::register));
            provider.registerPackets(new RegisterPacket(owner, Services.NETWORK::register));
            provider.registerParticleTypes(new RegisterParticleTypes(owner, (id, overrideLimit) -> {
                final class_2400 particleType = AccessSimpleParticleType.init(overrideLimit);
                class_2378.method_10230(class_7923.field_41180, id, particleType);
                return () -> particleType;
            }));
        });
    }
}