package net.darkhax.bookshelf.common.mixin.patch.packs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;

@Mixin(class_4309.class)
public class MixinSimpleJsonResourceReloadListener {

    /**
     * This patch introduces load conditions for all JSON based resource loaders. These conditions are independent of
     * the loader platform allowing them to be used in loader agnostic sourcesets.
     */
    @Inject(method = "prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Ljava/util/Map;", at = @At("RETURN"))
    private void prepare(class_3300 manager, class_3695 profiler, CallbackInfoReturnable<Map<class_2960, JsonElement>> cbi) {
        cbi.getReturnValue().entrySet().removeIf(entry -> entry.getValue() instanceof JsonObject obj && !LoadConditions.canLoad(obj));
    }
}