package net.darkhax.bookshelf.common.mixin.patch;

import net.darkhax.bookshelf.common.api.registry.register.RegisterCatVariant;
import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.class_2378;
import net.minecraft.class_7375;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_7375.class)
public class MixinCatVariant {

    @Inject(method = "bootstrap(Lnet/minecraft/core/Registry;)Lnet/minecraft/world/entity/animal/CatVariant;", at = @At("RETURN"))
    private static void onBootstrap(class_2378<class_7375> registry, CallbackInfoReturnable<class_7375> cir) {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            final String owner = provider.contentNamespace();
            provider.registerCatVariants(new RegisterCatVariant(owner, (key, texture) -> class_2378.method_39197(registry, key, new class_7375(texture))));
        });
    }
}
