package net.darkhax.bookshelf.common.impl.data.ingredient;

import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.ingredient.IngredientLogic;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.List;

public class EitherIngredient implements IngredientLogic<EitherIngredient> {

    public static final MapCodec<EitherIngredient> CODEC = MapCodecs.flexibleList(class_1856.field_46095).xmap(EitherIngredient::new, i -> i.ingredients).fieldOf("ingredients");
    public static final class_9139<class_9129, EitherIngredient> STREAM = StreamCodecs.list(class_1856.field_48355).method_56432(EitherIngredient::new, v -> v.ingredients);

    private final List<class_1856> ingredients;

    public EitherIngredient(List<class_1856> ingredients) {
        this.ingredients = ingredients;
    }

    @Override
    public boolean test(class_1799 stack) {
        for (class_1856 ingredient : this.ingredients) {
            if (ingredient.method_8093(stack)) {
                return true;
            }
        }
        return false;
    }
}
