package net.darkhax.bookshelf.common.impl.data.criterion.trigger;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_8779;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import java.util.Set;

public class AdvancementTrigger extends class_4558<AdvancementTrigger.Instance> {

    public static final AdvancementTrigger TRIGGER = new AdvancementTrigger();
    private static final Codec<AdvancementTrigger.Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2048.field_47250.optionalFieldOf("player").forGetter(Instance::comp_2029),
            MapCodecs.RESOURCE_LOCATION.getSet("advancements", Instance::advancementIds)
    ).apply(instance, Instance::new));

    @Override
    @NotNull
    public Codec<AdvancementTrigger.Instance> method_54937() {
        return CODEC;
    }

    public void trigger(class_3222 player, class_8779 advancement) {
        this.method_22510(player, instance -> instance.advancementIds().contains(advancement.comp_1919()));
    }

    public record Instance(Optional<class_5258> player, Set<class_2960> advancementIds) implements class_4558.class_8788 {

        @Override
        @NotNull
        public Optional<class_5258> comp_2029() {
            return this.player;
        }
    }
}
