package net.darkhax.bookshelf.common.api.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_5819;

public class MathsHelper {

    /**
     * A RNG source that can be used in contexts where a more suitable RNG source is not available.
     */
    public static final Random RANDOM = new SecureRandom();

    /**
     * A RandomSource that can be used in contexts where a more suitable RNG source is not available.
     */
    public static final class_5819 RANDOM_SOURCE = class_5819.method_43047();

    /**
     * A decimal format that will only preserve two decimal places.
     */
    public static final DecimalFormat DECIMAL_2 = new DecimalFormat("##.##");

    /**
     * Checks if a double is within the given range.
     *
     * @param min   The smallest value that is valid.
     * @param max   The largest value that is valid.
     * @param value The value to check.
     * @return If the value is within the defined range.
     */
    public static boolean inRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    /**
     * Calculates the distance between two points.
     *
     * @param first  The first position.
     * @param second The second position.
     * @return The distance between the first and second position.
     */
    public static double distance(class_243 first, class_243 second) {
        final double distanceX = first.field_1352 - second.field_1352;
        final double distanceY = first.field_1351 - second.field_1351;
        final double distanceZ = first.field_1350 - second.field_1350;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    /**
     * Rounds a double with a certain amount of precision.
     *
     * @param value  The value to round.
     * @param places The amount of decimal places to preserve.
     * @return The rounded value.
     */
    public static double round(double value, int places) {
        return value >= 0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    /**
     * Generates a pseudorandom number within a given range of values. The range of values is inclusive of the minimum
     * and maximum value.
     *
     * @param rng The RNG source to generate the number.
     * @param min The minimum value to generate.
     * @param max The maximum value to generate.
     * @return A pseudorandom number within the provided range.
     */
    public static int nextInt(Random rng, int min, int max) {
        return rng.nextInt(max - min + 1) + min;
    }

    /**
     * Generates a pseudorandom number within a given range of values. The range of values is inclusive of the minimum
     * and maximum value.
     *
     * @param rng The RNG source to generate the number.
     * @param min The minimum value to generate.
     * @param max The maximum value to generate.
     * @return A pseudorandom number within the provided range.
     */
    public static int nextInt(class_5819 rng, int min, int max) {
        return rng.method_39332(min, max);
    }

    /**
     * Performs an RNG check that has a percent chance to succeed.
     *
     * @param chance The chance that the check will succeed.
     * @return Returns true when the RNG check is successful.
     */
    public static boolean percentChance(double chance) {
        return Math.random() < chance;
    }

    /**
     * Calculates the average of many integers.
     *
     * @param values The values to average.
     * @return The average of the input values.
     */
    public static float average(int... values) {
        return Arrays.stream(values).sum() / (float) values.length;
    }

    /**
     * Calculates the percentage out of a total.
     *
     * @param value The value that is available.
     * @param total The largest possible value.
     * @return The calculated percentage.
     */
    public static float percentage(int value, int total) {
        return (float) value / (float) total;
    }

    /**
     * Converts a standard pixel measurement to a world-space measurement. This assumes one block in the world
     * represents 16 pixels.
     *
     * @param pixels The amount of pixels.
     * @return The size of the pixels in the world-space.
     */
    public static double pixelSize(int pixels) {
        return pixels / 16d;
    }

    /**
     * Creates an Axis Aligned Bounding Box from a series of pixel measurements.
     *
     * @param minX The start on the X axis.
     * @param minY The start on the Y axis.
     * @param minZ The start on the Z axis.
     * @param maxX The end on the X axis.
     * @param maxY The end on the Y axis.
     * @param maxZ The end on the Z axis.
     * @return An AABB that represents a series of block pixel measurements.
     */
    public static class_238 boundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new class_238(pixelSize(minX), pixelSize(minY), pixelSize(minZ), pixelSize(maxX), pixelSize(maxY), pixelSize(maxZ));
    }

    /**
     * Creates horizontally rotated variants of a VoxelShape. The input values are considered to be rotated north.
     *
     * @param minX The min X of the shape.
     * @param minY The min Y of the shape.
     * @param minZ The min Z of the shape.
     * @param maxX The max X of the shape.
     * @param maxY The max Y of the shape.
     * @param maxZ The max Z of the shape.
     * @return A map of rotated VoxelShape.
     */
    public static Map<class_2350, class_265> createHorizontalShapes(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {

        final Map<class_2350, class_265> shapes = new EnumMap<>(class_2350.class);
        class_2350.class_2353.field_11062.forEach(dir -> shapes.put(dir, rotateShape(dir, minX, minY, minZ, maxX, maxY, maxZ)));
        return shapes;
    }

    /**
     * Creates a VoxelShape that has been rotated to face a given direction. The input sizes are considered to be
     * rotated north already. The up/down rotations are not supported yet.
     *
     * @param facing
     * @param x1     The min x coordinate.
     * @param y1     The min y coordinate.
     * @param z1     The min z coordinate.
     * @param x2     The max x coordinate.
     * @param y2     The max y coordinate.
     * @param z2     The max z coordinate.
     * @return The rotated VoxelShape.
     */
    public static class_265 rotateShape(class_2350 facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (facing) {
            case field_11043 -> class_2248.method_9541(x1, y1, z1, x2, y2, z2);
            case field_11034 -> class_2248.method_9541(16 - z2, y1, x1, 16 - z1, y2, x2);
            case field_11035 -> class_2248.method_9541(16 - x2, y1, 16 - z2, 16 - x1, y2, 16 - z1);
            case field_11039 -> class_2248.method_9541(z1, y1, 16 - x2, z2, y2, 16 - x1);
            default -> throw new IllegalArgumentException("Can not rotate face in direction " + facing.name());
        };
    }


    /**
     * Offsets a position horizontally by a random amount.
     *
     * @param startPos The starting position to offset from.
     * @param rng      The RNG source.
     * @param range    The maximum amount of blocks to offset the position by. This range applies to both the positive
     *                 and negative directions.
     * @return The randomly offset position.
     */
    public static class_2338 randomOffsetHorizontal(class_2338 startPos, class_5819 rng, int range) {
        return randomOffset(startPos, rng, range, 0, range);
    }

    /**
     * Offsets a position by a random amount within a limited range.
     *
     * @param startPos The starting position to offset from.
     * @param rng      The RNG source.
     * @param rangeX   The maximum amount of blocks to offset on the X axis.
     * @param rangeY   The maximum amount of blocks to offset on the Y axis.
     * @param rangeZ   The maximum amount of blocks to offset on the Z axis.
     * @return The randomly offset position.
     */
    public static class_2338 randomOffset(class_2338 startPos, class_5819 rng, int rangeX, int rangeY, int rangeZ) {
        if (rangeX < 0 || rangeY < 0 || rangeZ < 0) {
            throw new IllegalArgumentException("Cannot offset position by '" + rangeX + ", " + rangeY + ", " + rangeZ + "'. Range must be positive!");
        }
        final int offsetX = rangeX != 0 ? rng.method_39332(-rangeX, rangeX) : 0;
        final int offsetY = rangeY != 0 ? rng.method_39332(-rangeY, rangeY) : 0;
        final int offsetZ = rangeZ != 0 ? rng.method_39332(-rangeZ, rangeZ) : 0;
        return startPos.method_10069(offsetX, offsetY, offsetZ);
    }

}