package net.darkhax.bookshelf.common.api.util;

import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public interface IRenderHelper {

    IRenderHelper GET = Services.load(IRenderHelper.class);
    default class_1058 blockSprite(class_2960 texturePath) {
        return class_310.method_1551().method_1549(class_1723.field_21668).apply(texturePath);
    }

    void renderFluidBox(class_4587 pose, class_3610 fluidState, class_1937 level, class_2338 pos, class_4597 bufferSource, int light, int overlay);

    default int[] unpackARGB(int color) {
        return new int[]{color >> 24 & 0xff, color >> 24 & 0xff, color >> 8 & 0xff, color & 0xff};
    }

    default void renderBox(class_4588 builder, class_4587 stack, class_1058 sprite, int light, int overlay, int[] color) {
        renderBox(builder, stack.method_23760().method_23761(), sprite, light, overlay, 0f, 1f, 0f, 1f, 0f, 1f, color);
    }

    default void renderBox(class_4588 builder, class_4587 stack, class_1058 sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        renderBox(builder, stack.method_23760().method_23761(), sprite, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    default void renderBox(class_4588 builder, Matrix4f pos, class_1058 sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        renderFace(builder, pos, sprite, class_2350.field_11033, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11036, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11043, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11035, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11039, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11034, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    default void renderFace(class_4588 builder, Matrix4f pos, class_1058 sprite, class_2350 side, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        switch (side) {
            case field_11033 -> {
                final float u1 = sprite.method_4580(x1);
                final float u2 = sprite.method_4580(x2);
                final float v1 = sprite.method_4570(z1);
                final float v2 = sprite.method_4570(z2);
                builder.method_22918(pos, x1, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_60803(light).method_22914(0f, -1f, 0f);
                builder.method_22918(pos, x1, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(0f, -1f, 0f);
                builder.method_22918(pos, x2, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_60803(light).method_22914(0f, -1f, 0f);
                builder.method_22918(pos, x2, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_60803(light).method_22914(0f, -1f, 0f);
            }
            case field_11036 -> {
                final float u1 = sprite.method_4580(x1);
                final float u2 = sprite.method_4580(x2);
                final float v1 = sprite.method_4570(z1);
                final float v2 = sprite.method_4570(z2);
                builder.method_22918(pos, x1, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_60803(light).method_22914(0f, 1f, 0f);
                builder.method_22918(pos, x2, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_60803(light).method_22914(0f, 1f, 0f);
                builder.method_22918(pos, x2, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_60803(light).method_22914(0f, 1f, 0f);
                builder.method_22918(pos, x1, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(0f, 1f, 0f);
            }
            case field_11043 -> {
                final float u1 = sprite.method_4580(x1);
                final float u2 = sprite.method_4580(x2);
                final float v1 = sprite.method_4570(y1);
                final float v2 = sprite.method_4570(y2);
                builder.method_22918(pos, x1, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(0f, 0f, -1f);
                builder.method_22918(pos, x1, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_60803(light).method_22914(0f, 0f, -1f);
                builder.method_22918(pos, x2, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_60803(light).method_22914(0f, 0f, -1f);
                builder.method_22918(pos, x2, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_60803(light).method_22914(0f, 0f, -1f);
            }
            case field_11035 -> {
                final float u1 = sprite.method_4580(x1);
                final float u2 = sprite.method_4580(x2);
                final float v1 = sprite.method_4570(y1);
                final float v2 = sprite.method_4570(y2);
                builder.method_22918(pos, x2, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_60803(light).method_22914(0f, 0f, 1f);
                builder.method_22918(pos, x2, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_60803(light).method_22914(0f, 0f, 1f);
                builder.method_22918(pos, x1, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_60803(light).method_22914(0f, 0f, 1f);
                builder.method_22918(pos, x1, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(0f, 0f, 1f);
            }
            case field_11039 -> {
                final float u1 = sprite.method_4580(y1);
                final float u2 = sprite.method_4580(y2);
                final float v1 = sprite.method_4570(z1);
                final float v2 = sprite.method_4570(z2);
                builder.method_22918(pos, x1, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_60803(light).method_22914(-1f, 0f, 0f);
                builder.method_22918(pos, x1, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_60803(light).method_22914(-1f, 0f, 0f);
                builder.method_22918(pos, x1, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_60803(light).method_22914(-1f, 0f, 0f);
                builder.method_22918(pos, x1, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(-1f, 0f, 0f);
            }
            case field_11034 -> {
                final float u1 = sprite.method_4580(y1);
                final float u2 = sprite.method_4580(y2);
                final float v1 = sprite.method_4570(z1);
                final float v2 = sprite.method_4570(z2);
                builder.method_22918(pos, x2, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_22914(1f, 0f, 0f);
                builder.method_22918(pos, x2, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_60803(light).method_22914(1f, 0f, 0f);
                builder.method_22918(pos, x2, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_60803(light).method_22914(1f, 0f, 0f);
                builder.method_22918(pos, x2, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_60803(light).method_22914(1f, 0f, 0f);
            }
        }
    }
}