package net.darkhax.bookshelf.common.api.util;

import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_3936;
import net.minecraft.class_3954;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;

public interface IGameplayHelper {

    class_5819 RNG = class_5819.method_43047();

    /**
     * Gets the crafting remainder for a given item. This is required as some platforms have different logic for
     * determining the crafting remainder.
     *
     * @param input The input item.
     * @return The crafting remainder, or empty if none.
     */
    default class_1799 getCraftingRemainder(class_1799 input) {
        if (input.method_7909().method_7857()) {
            final class_1792 remainder = input.method_7909().method_7858();
            if (remainder != null) {
                return remainder.method_7854();
            }
        }
        return class_1799.field_8037;
    }

    /**
     * If an inventory exists at the specified position, attempt to insert the item into all available slots until the
     * item has been fully inserted or no more slots are available.
     *
     * @param level The world instance.
     * @param pos   The position of the block.
     * @param side  The side you are accessing the inventory from. This is from the perspective of the inventory, not
     *              your block. For example a hopper on top of a chest is inserting downwards but would use the upwards
     *              face because that is the side of the chest being accessed.
     * @param stack The item to try inserting.
     * @return The remaining items that were not inserted.
     */
    default class_1799 inventoryInsert(class_3218 level, class_2338 pos, class_2350 side, class_1799 stack) {
        if (stack.method_7960()) {
            return stack;
        }
        final class_1263 container = getContainer(level, pos);
        return container != null ? class_2614.method_11260(null, container, stack, side) : stack;
    }

    /**
     * Gets a vanilla container for a given position. This method supports block based containers like the composter,
     * and block entity based containers like a chest or barrel.
     *
     * @param level The world instance.
     * @param pos   The position to check.
     * @return The container that was found, or null if no container exists.
     */
    @Nullable
    default class_1263 getContainer(class_3218 level, class_2338 pos) {
        final class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof class_3954 holder) {
            return holder.method_17680(state, level, pos);
        }
        final class_2586 be = level.method_8321(pos);
        if (be instanceof class_1263 beContainer) {
            return beContainer;
        }
        return null;
    }

    /**
     * Attempts to add an item to a list based inventory. This code will try to insert into all available slots until
     * the item has been completely inserted or no items remain.
     *
     * @param stack     The item to add into the inventory.
     * @param inventory The list of items to add to.
     * @param slots     An array of valid slots to add to.
     * @return The remaining items that were not inserted.
     */
    default class_1799 addItem(class_1799 stack, class_2371<class_1799> inventory, int[] slots) {
        for (int slot : slots) {
            if (stack.method_7960()) {
                return stack;
            }
            final class_1799 existing = inventory.get(slot);
            if (existing.method_7960()) {
                inventory.set(slot, stack);
                return class_1799.field_8037;
            }
            else if (existing.method_7947() < existing.method_7914() && class_1799.method_31577(existing, stack)) {
                final int availableSpace = existing.method_7914() - existing.method_7947();
                final int movedAmount = Math.min(stack.method_7947(), availableSpace);
                stack.method_7934(movedAmount);
                existing.method_7933(movedAmount);
            }
        }
        return stack;
    }

    /**
     * Creates a new block entity builder using platform specific code. This is required because the underlying block
     * entity factory is not accessible.
     *
     * @param factory     A factory that creates a new block entity instance.
     * @param validBlocks The array of valid blocks for the block entity.
     * @param <T>         The type of the block entity.
     * @return A new builder for your block entity type.
     */
    <T extends class_2586> class_2591.class_2592<T> blockEntityBuilder(BiFunction<class_2338, class_2680, T> factory, class_2248... validBlocks);


    /**
     * Binds a screen to a menu using platform specific code. This is required because the underlying screen factory is
     * not accessible.
     *
     * @param type    The menu type to bind the screen to.
     * @param factory A factory that constructs the screen instance.
     * @param <M>     The type of the menu.
     * @param <U>     The type of the screen.
     */
    <M extends class_1703, U extends class_437 & class_3936<M>> void bindMenu(class_3917<? extends M> type, RegisterMenuScreen.ScreenFactory<M, U> factory);

    /**
     * Drops the crafting remainder of an item into the world if the item has one.
     *
     * @param level The world to drop the item within.
     * @param pos   The position to spawn the items at.
     * @param old   The base item to spawn a remainder from.
     */
    default void dropRemainders(class_1937 level, class_2338 pos, class_1799 old) {
        if (!level.field_9236 && !old.method_7960()) {
            final class_1799 remainder = this.getCraftingRemainder(old);
            if (!remainder.method_7960()) {
                class_2248.method_9577(level, pos, remainder.method_7972());
            }
        }
    }

    class_1761.class_7913 tabBuilder();
}