package net.darkhax.bookshelf.common.api.text.format;

import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public interface IPropertyFormat {

    /**
     * A namespaced identifier that is used to derive localization keys for the format.
     *
     * @return The namespace ID for the format.
     */
    class_2960 formatKey();

    /**
     * Formats a property and value using the alignment.
     *
     * @param property The name of the property.
     * @param value    The value of the property.
     * @return A component that represents an aligned property and value.
     */
    default class_5250 format(class_2561 property, class_2561 value) {
        return TextHelper.fromResourceLocation("format", null, this.formatKey(), property, value);
    }
}
