package net.darkhax.bookshelf.common.api.loot;

import net.minecraft.class_1799;
import net.minecraft.class_79;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Optional;

/**
 * Describes the potential items that a loot pool entry can generate. See {@link LootPoolEntryDescriptions} for usage.
 */
@FunctionalInterface
public interface LootPoolEntryDescriber {

    /**
     * Generates a list of potential items that can be produced by the loot pool entry.
     *
     * @param server The current Minecraft server.
     * @param entry  The loot pool entry to be analyzed.
     * @return An optional list of items that can be produced by the entry. If the describer can not handle the provided
     * entry type it will be empty.
     */
    Optional<List<class_1799>> getPotentialDrops(@NotNull MinecraftServer server, @NotNull class_79 entry);
}