package net.darkhax.bookshelf.common.api.data.codecs.map;

import com.mojang.serialization.Codec;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6899;

public class RegistryMapCodecHelper<T> extends MapCodecHelper<class_6880<T>> {

    private final MapCodecHelper<class_6862<T>> tagHelper;

    private RegistryMapCodecHelper(Codec<class_6880<T>> holderCodec, class_5321<class_2378<T>> key) {
        super(holderCodec);
        this.tagHelper = new MapCodecHelper<>(class_6862.method_40090(key));
    }

    public MapCodecHelper<class_6862<T>> tag() {
        return this.tagHelper;
    }

    /**
     * Creates a Codec helper for a builtin registry.
     *
     * @param registry The registry to create a codec helper for.
     * @param <T>      The type of value held by the registry.
     * @return A Codec helper for a builtin registry.
     */
    public static <T> RegistryMapCodecHelper<T> create(class_2378<T> registry) {
        return new RegistryMapCodecHelper<>(registry.method_40294(), (class_5321<class_2378<T>>) registry.method_30517());
    }

    /**
     * Creates a Codec helper for a datapack registry. This codec can only be used when registry access is available
     * through RegistryOps.
     *
     * @param key The key of the registry to use.
     * @param <T> The type of value held by the registry.
     * @return A Codec helper for datapack entries.
     */
    public static <T> RegistryMapCodecHelper<T> create(class_5321<class_2378<T>> key) {
        return new RegistryMapCodecHelper<>(class_6899.method_40400(key), key);
    }
}