package net.darkhax.bookshelf.common.api.block;

import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public interface IBlockHooks {

    /**
     * Allows the block to determine its own pathfinding type.
     *
     * @param state   The current state of the block.
     * @param context Additional context from the world the block is in.
     * @param pos     The position of the block.
     * @return The pathfinding type for the block. If null is returned the vanilla behavior for determining pathfinding
     * will be used instead.
     */
    @Nullable
    default class_7 getPathfindingType(class_2680 state, class_1922 context, class_2338 pos) {
        return null;
    }
}