package net.darkhax.bookshelf.common.mixin.patch.loot;

import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.class_2378;
import net.minecraft.class_5338;
import net.minecraft.class_75;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_75.class)
public class MixinLootPoolEntries {

    @Inject(method = "<clinit>", at = @At("RETURN"))
    private static void classInit(CallbackInfo ci) {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            final String owner = provider.contentNamespace();
            provider.registerLootEntryType(new Register<>(owner, (id, codec) -> class_2378.method_10230(class_7923.field_41133, id, new class_5338(codec))));
        });
    }
}