package net.darkhax.bookshelf.common.mixin.patch.level;

import com.google.gson.JsonElement;
import net.darkhax.bookshelf.common.api.data.ISidedRecipeManager;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_8786;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;

@Mixin(class_1863.class)
public class MixinRecipeManager implements ISidedRecipeManager {

    @Unique
    private boolean bookshelf$isClient = false;

    @Unique
    private boolean bookshelf$isServer = false;

    @Inject(method = "apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V", at = @At("RETURN"))
    private void onReload(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        if (this.bookshelf$isServer) {
            Constants.SERVER_REVISION++;
        }
    }

    @Inject(method = "replaceRecipes", at = @At("RETURN"))
    private void onRecipesUpdated(Iterable<class_8786<?>> recipes, CallbackInfo ci) {
        if (this.bookshelf$isClient) {
            Constants.CLIENT_REVISION++;
        }
    }

    @Override
    public void bookshelf$setLogicalClient() {
        this.bookshelf$isClient = true;
        this.bookshelf$isServer = false;
    }

    @Override
    public void bookshelf$setLogicalServer() {
        this.bookshelf$isServer = true;
        this.bookshelf$isClient = false;
    }
}