package net.darkhax.bookshelf.common.api.registry.register;

import net.darkhax.bookshelf.common.api.data.loot.PoolTarget;
import net.darkhax.bookshelf.common.api.data.loot.modifiers.LootPoolAddition;
import net.darkhax.bookshelf.common.impl.data.loot.entries.LootItemStack;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_79;
import java.util.List;

/**
 * Registers new LootPoolAddition from various mods to be applied by Bookshelf.
 *
 * @param owner        The ID of the mod registering loot additions.
 * @param registerFunc The function used to register new additions.
 */
public record RegisterLootPoolAdditions(String owner, RegisterFunc registerFunc) {

    public void add(String id, PoolTarget pool, class_1799 item, int weight) {
        add(id, pool.table(), pool.index(), pool.hash(), item, weight);
    }

    public void add(String id, PoolTarget pool, class_1792 item, int weight) {
        add(id, pool.table(), pool.index(), pool.hash(), item, weight);
    }

    public void add(String id, class_5321<class_52> tableId, int poolIndex, int poolHash, class_1799 item, int weight) {
        add(id, tableId.method_29177(), poolIndex, poolHash, item, weight);
    }

    public void add(String id, class_2960 tableId, int poolIndex, int poolHash, class_1799 item, int weight) {
        add(id, tableId, poolIndex, poolHash, LootItemStack.of(item, weight));
    }

    public void add(String id, class_5321<class_52> tableId, int poolIndex, int poolHash, class_1792 item, int weight) {
        add(id, tableId.method_29177(), poolIndex, poolHash, item, weight);
    }

    public void add(String id, class_2960 tableId, int poolIndex, int poolHash, class_1792 item, int weight) {
        add(id, tableId, poolIndex, poolHash, AccessorLootItem.bookshelf$create(item.method_40131(), weight, 0, List.of(), List.of()));
    }

    public void add(String id, PoolTarget pool, class_79 addition) {
        add(id, pool.table(), pool.index(), pool.hash(), addition);
    }

    public void add(String id, class_5321<class_52> tableId, int poolIndex, int poolHash, class_79 addition) {
        add(id, tableId.method_29177(), poolIndex, poolHash, addition);
    }

    public void add(String id, class_2960 tableId, int poolIndex, int poolHash, class_79 addition) {
        registerFunc.register(tableId, poolIndex, poolHash, new LootPoolAddition(id(id), addition));
    }

    private class_2960 id(String id) {
        return class_2960.method_60655(this.owner, id);
    }

    @FunctionalInterface
    public interface RegisterFunc {
        void register(class_2960 tableId, int poolIndex, int poolHash, LootPoolAddition addition);
    }
}
