package net.darkhax.bookshelf.common.api.registry.register;

import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public record RegisterItemTab(String owner, BiConsumer<class_2960, class_1761> registerFunc) {

    public void add(String path, Supplier<class_1799> icon, class_1761.class_7914 display) {
        this.add(path, builder -> {
            builder.method_47321(this.title(path));
            builder.method_47320(icon);
            builder.method_47317(display);
        });
    }

    public void add(String path, Supplier<class_1799> icon) {
        this.add(path, builder -> {
            builder.method_47321(title(path));
            builder.method_47320(icon);
        });
    }

    public void add(String path, Consumer<class_1761.class_7913> builderFunc) {
        final class_1761.class_7913 builder = Services.GAMEPLAY.tabBuilder();
        builderFunc.accept(builder);
        this.add(path, builder.method_47324());
    }

    public void add(String path, class_1761 tab) {
        registerFunc.accept(class_2960.method_60655(this.owner, path), tab);
    }

    public class_2561 title(String path) {
        return class_2561.method_43471("itemGroup." + owner + "." + path);
    }
}