package net.darkhax.bookshelf.common.api.network;

import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

/**
 * A basic packet implementation.
 *
 * @param <T> The type of the payload.
 */
public abstract class AbstractPacket<T extends class_8710> implements IPacket<T> {

    /**
     * The type of the payload.
     */
    private final class_8710.class_9154<T> type;

    /**
     * A codec to serialize the payload.
     */
    private final class_9139<class_9129, T> codec;

    /**
     * The intended destination of the payload.
     */
    private final Destination direction;

    /**
     * A packet that is sent from the server to the client.
     *
     * @param id    The packet ID.
     * @param codec The payload codec.
     */
    public AbstractPacket(class_2960 id, class_9139<class_9129, T> codec) {
        this(id, codec, Destination.SERVER_TO_CLIENT);
    }

    /**
     * A simple packet type.
     *
     * @param id        The packet ID.
     * @param codec     The payload codec.
     * @param direction The intended destination of the packet.
     */
    public AbstractPacket(class_2960 id, class_9139<class_9129, T> codec, Destination direction) {
        this.type = new class_8710.class_9154<>(id);
        this.codec = codec;
        this.direction = direction;
    }

    @Override
    public class_8710.class_9154<T> type() {
        return this.type;
    }

    @Override
    public class_9139<class_9129, T> streamCodec() {
        return this.codec;
    }

    @Override
    public Destination destination() {
        return this.direction;
    }
}