package net.darkhax.bookshelf.common.api.commands.args;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.NotNull;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_7157;
import net.minecraft.class_9139;

public class ArgumentSerializer<T extends ArgumentType<?>, V> implements class_2314<T, ArgumentSerializer.ArgTemplate<T, V>> {

    private final MapCodec<V> codec;
    private final class_9139<class_2540, V> stream;
    private final BiFunction<class_7157, V, T> fromData;
    private final Function<T, V> toData;

    public ArgumentSerializer(MapCodec<V> codec, class_9139<class_2540, V> stream, BiFunction<class_7157, V, T> mapFunc, Function<T, V> toData) {
        this.codec = codec;
        this.stream = stream;
        this.fromData = mapFunc;
        this.toData = toData;
    }

    @Override
    public void serializeToNetwork(ArgTemplate<T, V> template, @NotNull class_2540 buf) {
        this.stream.encode(buf, template.data);
    }

    @NotNull
    @Override
    public ArgTemplate<T, V> method_10005(@NotNull class_2540 buf) {
        return new ArgTemplate<>(this, this.stream.decode(buf));
    }

    @Override
    public void serializeToJson(@NotNull ArgTemplate<T, V> template, @NotNull JsonObject json) {
        json.add("value", this.codec.codec().encodeStart(JsonOps.INSTANCE, template.data).getOrThrow());
    }

    @NotNull
    @Override
    public ArgTemplate<T, V> method_41726(@NotNull T t) {
        return new ArgTemplate<>(this, this.toData.apply(t));
    }

    public static class ArgTemplate<T extends ArgumentType<?>, V> implements class_2314.class_7217<T> {

        private final ArgumentSerializer<T, V> type;
        private final V data;

        protected ArgTemplate(ArgumentSerializer<T, V> type, V data) {
            this.type = type;
            this.data = data;
        }

        @NotNull
        @Override
        public T method_41730(@NotNull class_7157 ctx) {
            return this.type.fromData.apply(ctx, this.data);
        }

        @NotNull
        @Override
        public class_2314<T, ?> method_41728() {
            return this.type;
        }
    }
}