package net.darkhax.bookshelf.common.mixin.patch.item;

import net.darkhax.bookshelf.common.api.item.IItemHooks;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Mixin(class_1761.class)
public class MixinCreativeModeTab {

    @Shadow
    private Collection<class_1799> displayItems;

    @Shadow
    private Set<class_1799> displayItemsSearchTab;

    @Unique
    private static final Map<class_2960, class_6862<class_1792>> TAG_CACHE = new HashMap<>();

    @Unique
    private static final class_2960 OP_ITEMS_ID = class_2960.method_60655("minecraft", "op_blocks");

    @Inject(method = "buildContents(Lnet/minecraft/world/item/CreativeModeTab$ItemDisplayParameters;)V", at = @At("TAIL"))
    private void buildContents(class_1761.class_8128 parameters, CallbackInfo cbi) {
        final class_1761 self = (class_1761) (Object) this;
        final class_2960 id = class_7923.field_44687.method_10221(self);
        if (id != null && (!self.method_7752() || id.equals(OP_ITEMS_ID)) && (!id.equals(OP_ITEMS_ID) || parameters.comp_1252())) {
            final class_6862<class_1792> tabTag = TAG_CACHE.computeIfAbsent(id, key -> class_6862.method_40092(class_7924.field_41197, Constants.id("creative_tab/" + key.method_12836() + "/" + key.method_12832())));
            for (class_6880<class_1792> tagEntry : DataHelper.getTagOrEmpty(parameters.comp_1253(), class_7924.field_41197, tabTag)) {
                try {
                    final class_1792 item = tagEntry.comp_349();
                    if (item instanceof IItemHooks hooks) {
                        hooks.addCreativeTabForms(self, stack -> {
                            displayItems.add(stack);
                            displayItemsSearchTab.add(stack);
                        });
                    }
                    else {
                        final class_1799 stack = new class_1799(item);
                        displayItems.add(stack);
                        displayItemsSearchTab.add(stack);
                    }
                }
                catch (Exception e) {
                    Constants.LOG.error("Unable to add tag entries to creative tab!", e);
                }
            }
        }
    }
}
