package net.darkhax.bookshelf.common.mixin.patch.component;

import net.darkhax.bookshelf.common.api.registry.register.ItemComponentRegister;
import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.UnaryOperator;

@Mixin(class_9334.class)
public class MixinDataComponents {

    @Inject(method = "bootstrap(Lnet/minecraft/core/Registry;)Lnet/minecraft/core/component/DataComponentType;", at = @At("RETURN"))
    private static void bootstrap(class_2378<class_9331<?>> registry, CallbackInfoReturnable<class_9331<?>> cir) {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            // This code is convoluted, but it allows the type parameters
            // of the private method to be preserved. Note that lambda
            // expressions can not implement functional interfaces with
            // type parameters.
            final ItemComponentRegister register = new ItemComponentRegister() {
                @Override
                public <T> void accept(String name, UnaryOperator<class_9331.class_9332<T>> builder) {
                    register(provider.contentNamespace() + ":" + name, builder);
                }

                @Override
                public <T> void accept(class_2960 id, UnaryOperator<class_9331.class_9332<T>> builder) {
                    register(id.toString(), builder);
                }
            };
            provider.registerItemComponents(register);
        });
    }

    @Shadow
    private static <T> class_9331<T> register(String name, UnaryOperator<class_9331.class_9332<T>> builder) {
        throw new IllegalStateException("Mixin failed to apply.");
    }
}