package net.darkhax.bookshelf.common.impl.data.ingredient;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.ingredient.IngredientLogic;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.List;

public class ModIdIngredient implements IngredientLogic<ModIdIngredient> {

    public static final MapCodec<ModIdIngredient> CODEC = MapCodecs.flexibleList(Codec.STRING).xmap(ModIdIngredient::new, i -> i.modIds).fieldOf("mod");
    public static final class_9139<class_9129, ModIdIngredient> STREAM = StreamCodecs.list(StreamCodecs.STRING).method_56432(ModIdIngredient::new, i -> i.modIds);

    private final List<String> modIds;

    public ModIdIngredient(List<String> modIds) {
        this.modIds = modIds;
    }

    @Override
    public boolean test(class_1799 stack) {
        final String owner = class_7923.field_41178.method_10221(stack.method_7909()).method_12836();
        for (String id : this.modIds) {
            if (owner.equals(id)) {
                return true;
            }
        }
        return false;
    }
}
