package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2168;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;

public enum HandCommand implements IEnumCommand {

    ID((stack, level) -> TextHelper.copyText(Objects.requireNonNull(level.method_30349().method_30530(class_7924.field_41197).method_10221(stack.method_7909())).toString())),
    STRING((stack, level) -> TextHelper.copyText(stack.toString())),
    INGREDIENT(json(MapCodecs.INGREDIENT.get(), (stack, level) -> class_1856.method_8101(stack))),
    STACK_JSON(json(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack)),
    STACK_NBT(nbt(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack)),
    COMPONENTS((stack, level) -> {
        final StringJoiner joiner = new StringJoiner("\n");
        stack.method_57353().method_57833().sorted(Comparator.comparing(r -> r.comp_2443().toString())).forEach(component -> {
            joiner.add(component.comp_2443() + " = " + unsafeEncode(Objects.requireNonNull(component.comp_2443().method_57875()), class_2509.field_11560, component.comp_2444()));
        });
        return TextHelper.copyText(joiner.toString());
    }),
    TAGS(((stack, level) -> {
        final StringJoiner joiner = new StringJoiner("\n");
        stack.method_40133().map(key -> key.comp_327().toString()).sorted().forEach(joiner::add);
        return TextHelper.copyText(joiner.toString());
    }));

    private final ItemFormat format;

    HandCommand(ItemFormat format) {
        this.format = format;
    }

    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        final class_2168 source = context.getSource();
        if (source.method_9228() instanceof class_1309 living) {
            context.getSource().method_9226(() -> this.format.formatItem(living.method_6047(), source.method_9225()), false);
        }
        return Command.SINGLE_SUCCESS;
    }

    private static <T> ItemFormat json(Codec<T> codec, BiFunction<class_1799, class_3218, T> mapper) {
        return fromCodec(JsonOps.INSTANCE, Constants.GSON_PRETTY::toJson, codec, mapper);
    }

    private static <T> ItemFormat nbt(Codec<T> codec, BiFunction<class_1799, class_3218, T> mapper) {
        return fromCodec(class_2509.field_11560, class_2520::toString, codec, mapper);
    }

    private static <T, D> ItemFormat fromCodec(DynamicOps<D> ops, Function<D, String> dataFormatter, Codec<T> codec, BiFunction<class_1799, class_3218, T> mapper) {
        return (stack, level) -> {
            if (stack.method_7960()) {
                return class_2561.method_43471("commands.bookshelf.hand.error.not_air").method_27692(class_124.field_1061);
            }
            final T value = mapper.apply(stack, level);
            final D data = codec.encodeStart(class_6903.method_46632(ops, level.method_30349()), value).getOrThrow();
            return TextHelper.copyText(dataFormatter.apply(data));
        };
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    private static <T> T unsafeEncode(Codec codec, DynamicOps<T> ops, Object input) {
        return (T) codec.encodeStart(ops, input).getOrThrow();
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LiteralArgumentBuilder<class_2168> build(class_7157 context) {
        return CommandHelper.buildFromEnum("hand", HandCommand.class);
    }

    interface ItemFormat {
        class_2561 formatItem(class_1799 stack, class_3218 level);
    }
}