package net.darkhax.bookshelf.common.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;

public class Constants {

    public static final String MOD_ID = "bookshelf";
    public static final String MOD_NAME = "Bookshelf";
    public static final Logger LOG = LoggerFactory.getLogger(MOD_NAME);
    public static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, class_2960> ID_CACHE = new HashMap<>();

    public static class_2960 id(String path) {
        return ID_CACHE.computeIfAbsent(path, p -> class_2960.method_43902(MOD_ID, p));
    }

    public static WeakReference<class_1863> SERVER_RECIPE_MANAGER;
    public static int SERVER_REVISION = 0;

    public static WeakReference<class_1863> CLIENT_RECIPE_MANAGER;
    public static int CLIENT_REVISION = 0;
}