package net.darkhax.bookshelf.common.api.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.registry.register.ArgumentRegister;
import net.darkhax.bookshelf.common.api.registry.register.ItemComponentRegister;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterBlockEntityRenderer;
import net.darkhax.bookshelf.common.api.registry.register.RegisterCatVariant;
import net.darkhax.bookshelf.common.api.registry.register.RegisterIngredient;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterLootPoolAdditions;
import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.darkhax.bookshelf.common.api.registry.register.RegisterPacket;
import net.darkhax.bookshelf.common.api.registry.register.RegisterParticleProviders;
import net.darkhax.bookshelf.common.api.registry.register.RegisterParticleTypes;
import net.darkhax.bookshelf.common.api.registry.register.RegisterPotPatterns;
import net.darkhax.bookshelf.common.api.registry.register.RegisterRecipeType;
import net.darkhax.bookshelf.common.api.registry.register.RegisterVillagerTrades;
import net.minecraft.class_117;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_179;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1921;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_5341;
import net.minecraft.class_7157;
import net.minecraft.class_79;
import net.minecraft.class_9360;
import java.util.function.BiConsumer;

public interface IContentProvider {

    String contentNamespace();

    default void registerMobEffects(Register<class_1291> registry) {
    }

    default void registerBlocks(Register<class_2248> registry) {
    }

    default void registerEntities(Register<class_1299.class_1300<?>> registry) {
    }

    /**
     * @deprecated Please use {@link #registerItems(RegisterItem)}
     */
    @Deprecated
    default void registerItems(Register<class_1792> registry) {
    }

    default void registerItems(RegisterItem registry) {
    }

    default void registerBlockEntities(Register<class_2591.class_2592<?>> registry) {
    }

    default void registerRecipeTypes(RegisterRecipeType registry) {
    }

    default void registerRecipeSerializers(Register<class_1865<?>> registry) {
    }

    default void registerAttributes(Register<class_1320> registry) {
    }

    default void registerItemSubPredicates(Register<class_9360.class_8745<?>> registry) {
    }

    default void registerCriteriaTriggers(Register<class_179<?>> registry) {
    }

    default void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
    }

    default void registerCommandArguments(ArgumentRegister registry) {
    }

    default void registerItemComponents(ItemComponentRegister registry) {
    }

    default void registerLoadConditions(Register<MapCodec<? extends ILoadCondition>> registry) {
    }

    default void registerLootEntryType(Register<MapCodec<? extends class_79>> register) {
    }

    default void registerPotPatterns(RegisterPotPatterns registry) {
    }

    default void registerMenus(MenuRegister registry) {
    }

    default void registerLootConditions(Register<MapCodec<? extends class_5341>> registry) {
    }

    default void registerLootFunctions(Register<MapCodec<? extends class_117>> registry) {
    }

    default void registerPackets(RegisterPacket registry) {
    }

    default void registerTrades(RegisterVillagerTrades registry) {
    }

    default void registerParticleTypes(RegisterParticleTypes registry) {
    }

    default void registerLootPoolAdditions(RegisterLootPoolAdditions registry) {
    }

    default void registerCatVariants(RegisterCatVariant registry) {
    }

    default void registerItemTabs(RegisterItemTab registry) {
    }

    default void registerIngredientTypes(RegisterIngredient registry) {
    }

    @OnlyFor(PhysicalSide.CLIENT)
    default void registerMenuScreens(RegisterMenuScreen registry) {
    }

    @OnlyFor(PhysicalSide.CLIENT)
    default void registerParticleFactories(RegisterParticleProviders registry) {
    }

    @OnlyFor(PhysicalSide.CLIENT)
    default void bindRenderLayers(BiConsumer<class_2248, class_1921> registry) {
    }

    @OnlyFor(PhysicalSide.CLIENT)
    default void bindBlockEntityRenderer(RegisterBlockEntityRenderer registry) {
    }
}