package net.darkhax.bookshelf.common.api.commands.args;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.text.font.BuiltinFonts;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2960;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class FontArgument implements ArgumentType<class_2960> {

    public static final FontArgument ARGUMENT = new FontArgument();
    public static final class_2314<FontArgument, ?> SERIALIZER = SingletonArgumentInfo.of(() -> ARGUMENT);
    private static final Set<String> EXAMPLES = Set.of(BuiltinFonts.DEFAULT.identifier().toString(), BuiltinFonts.ALT.identifier().toString(), BuiltinFonts.ILLAGER.identifier().toString());

    public static class_2960 get(CommandContext<class_2168> context) {
        return get("font", context);
    }

    public static class_2960 get(String argName, CommandContext<class_2168> context) {
        return context.getArgument(argName, class_2960.class);
    }

    public static RequiredArgumentBuilder<class_2168, class_2960> argument() {
        return argument("font");
    }

    public static RequiredArgumentBuilder<class_2168, class_2960> argument(String argName) {
        return class_2170.method_9244(argName, ARGUMENT);
    }

    @Override
    public class_2960 parse(StringReader reader) throws CommandSyntaxException {
        return class_2960.method_12835(reader);
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (Services.PLATFORM.isPhysicalClient()) {
            return class_2172.method_9270(TextHelper.getRegisteredFonts(), builder);
        }
        return class_2172.method_9270(BuiltinFonts.FONT_IDS, builder);
    }
}